/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.asymmetric.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.SignedData;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private List certificates;

    private List sortCerts(List certs) {
        int i2;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i3 = 1; i3 != certs.size(); ++i3) {
            X509Certificate cert = (X509Certificate)certs.get(i3);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i3)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i2 = 0; i2 < certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j2 = 0; j2 != certs.size(); ++j2) {
                X509Certificate c2 = (X509Certificate)certs.get(j2);
                if (!c2.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i2);
        }
        if (retList.size() > 1) {
            return orig;
        }
        block3: for (i2 = 0; i2 != retList.size(); ++i2) {
            issuer = ((X509Certificate)retList.get(i2)).getIssuerX500Principal();
            for (int j3 = 0; j3 < certs.size(); ++j3) {
                X509Certificate c3 = (X509Certificate)certs.get(j3);
                if (!issuer.equals(c3.getSubjectX500Principal())) continue;
                retList.add(c3);
                certs.remove(j3);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    PKIXCertPath(List certificates) {
        super("X.509");
        this.certificates = this.sortCerts(new ArrayList(certificates));
    }

    PKIXCertPath(InputStream inStream, String encoding) throws CertificateException {
        block8: {
            super("X.509");
            try {
                if (encoding.equalsIgnoreCase("PkiPath")) {
                    ASN1InputStream derInStream = new ASN1InputStream(inStream);
                    ASN1Primitive derObject = derInStream.readObject();
                    if (!(derObject instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration e2 = ((ASN1Sequence)derObject).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
                    while (e2.hasMoreElements()) {
                        ASN1Encodable element = (ASN1Encodable)e2.nextElement();
                        byte[] encoded = element.toASN1Primitive().getEncoded("DER");
                        this.certificates.add(0, certFactory.generateCertificate(new ByteArrayInputStream(encoded)));
                    }
                    break block8;
                }
                if (encoding.equalsIgnoreCase("PKCS7") || encoding.equalsIgnoreCase("PEM")) {
                    Certificate cert;
                    inStream = new BufferedInputStream(inStream);
                    this.certificates = new ArrayList();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
                    while ((cert = certFactory.generateCertificate(inStream)) != null) {
                        this.certificates.add(cert);
                    }
                    break block8;
                }
                throw new CertificateException("unsupported encoding: " + encoding);
            }
            catch (IOException ex2) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + ex2.toString());
            }
            catch (NoSuchProviderException ex3) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + ex3.toString());
            }
        }
        this.certificates = this.sortCerts(this.certificates);
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        Object enc;
        Iterator iter = this.getEncodings();
        if (iter.hasNext() && (enc = iter.next()) instanceof String) {
            return this.getEncoded((String)enc);
        }
        return null;
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (encoding.equalsIgnoreCase("PkiPath")) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            ListIterator iter = this.certificates.listIterator(this.certificates.size());
            while (iter.hasPrevious()) {
                v2.add(this.toASN1Object((X509Certificate)iter.previous()));
            }
            return this.toDEREncoded(new DERSequence(v2));
        }
        if (encoding.equalsIgnoreCase("PKCS7")) {
            ContentInfo encInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
            ASN1EncodableVector v3 = new ASN1EncodableVector();
            for (int i2 = 0; i2 != this.certificates.size(); ++i2) {
                v3.add(this.toASN1Object((X509Certificate)this.certificates.get(i2)));
            }
            SignedData sd = new SignedData(new ASN1Integer(1L), new DERSet(), encInfo, new DERSet(v3), null, new DERSet());
            return this.toDEREncoded(new ContentInfo(PKCSObjectIdentifiers.signedData, sd));
        }
        if (encoding.equalsIgnoreCase("PEM")) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            PemWriter pWrt = new PemWriter(new OutputStreamWriter(bOut));
            try {
                for (int i3 = 0; i3 != this.certificates.size(); ++i3) {
                    pWrt.writeObject(new PemObject("CERTIFICATE", ((X509Certificate)this.certificates.get(i3)).getEncoded()));
                }
                pWrt.close();
            }
            catch (Exception exception) {
                throw new CertificateEncodingException("can't encode certificate for PEM encoded path");
            }
            return bOut.toByteArray();
        }
        throw new CertificateEncodingException("unsupported encoding: " + encoding);
    }

    public List getCertificates() {
        return Collections.unmodifiableList(new ArrayList(this.certificates));
    }

    private ASN1Primitive toASN1Object(X509Certificate cert) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(cert.getEncoded()).readObject();
        }
        catch (Exception e2) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + e2.toString());
        }
    }

    private byte[] toDEREncoded(ASN1Encodable obj) throws CertificateEncodingException {
        try {
            return obj.toASN1Primitive().getEncoded("DER");
        }
        catch (IOException e2) {
            throw new CertificateEncodingException("Exception thrown: " + e2);
        }
    }

    static {
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("PkiPath");
        encodings.add("PEM");
        encodings.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(encodings);
    }
}

