/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.mail.smime;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedDataGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.RecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEException;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEGenerator;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import com.timevale.tgtext.bouncycastle.mail.smime.SMIMEUtil;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.activation.n;
import javax.crypto.SecretKey;
import javax.mail.internet.j;
import javax.mail.internet.k;
import javax.mail.q;

public class SMIMEEnvelopedGenerator
extends SMIMEGenerator {
    public static final String DES_EDE3_CBC = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
    public static final String RC2_CBC = CMSEnvelopedDataGenerator.RC2_CBC;
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = CMSEnvelopedDataGenerator.AES128_CBC;
    public static final String AES192_CBC = CMSEnvelopedDataGenerator.AES192_CBC;
    public static final String AES256_CBC = CMSEnvelopedDataGenerator.AES256_CBC;
    public static final String CAMELLIA128_CBC = CMSEnvelopedDataGenerator.CAMELLIA128_CBC;
    public static final String CAMELLIA192_CBC = CMSEnvelopedDataGenerator.CAMELLIA192_CBC;
    public static final String CAMELLIA256_CBC = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
    public static final String SEED_CBC = CMSEnvelopedDataGenerator.SEED_CBC;
    public static final String DES_EDE3_WRAP = CMSEnvelopedDataGenerator.DES_EDE3_WRAP;
    public static final String AES128_WRAP = CMSEnvelopedDataGenerator.AES128_WRAP;
    public static final String AES256_WRAP = CMSEnvelopedDataGenerator.AES256_WRAP;
    public static final String CAMELLIA128_WRAP = CMSEnvelopedDataGenerator.CAMELLIA128_WRAP;
    public static final String CAMELLIA192_WRAP = CMSEnvelopedDataGenerator.CAMELLIA192_WRAP;
    public static final String CAMELLIA256_WRAP = CMSEnvelopedDataGenerator.CAMELLIA256_WRAP;
    public static final String SEED_WRAP = CMSEnvelopedDataGenerator.SEED_WRAP;
    public static final String ECDH_SHA1KDF = CMSEnvelopedDataGenerator.ECDH_SHA1KDF;
    private static final String ENCRYPTED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data";
    private b fact;
    private List recipients = new ArrayList();

    private static n addCommands(javax.activation.c c2) {
        n n2 = (n)c2;
        n2.d("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        n2.d("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        n2.d("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        n2.d("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        n2.d("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return n2;
    }

    public SMIMEEnvelopedGenerator() {
        this.fact = new b();
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGenerator) throws IllegalArgumentException {
        this.fact.addRecipientInfoGenerator(recipientInfoGenerator);
    }

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        try {
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate);
            this.recipients.add(jceKeyTransRecipientInfoGenerator);
            this.fact.addRecipientInfoGenerator(jceKeyTransRecipientInfoGenerator);
            return;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalArgumentException(certificateEncodingException.toString());
        }
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(byArray, publicKey);
        this.recipients.add(jceKeyTransRecipientInfoGenerator);
        this.fact.addRecipientInfoGenerator(jceKeyTransRecipientInfoGenerator);
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) throws IllegalArgumentException {
        JceKEKRecipientInfoGenerator jceKEKRecipientInfoGenerator = new JceKEKRecipientInfoGenerator(byArray, secretKey);
        this.recipients.add(jceKEKRecipientInfoGenerator);
        this.fact.addRecipientInfoGenerator(jceKEKRecipientInfoGenerator);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, string3);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, Provider provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(new ASN1ObjectIdentifier(string), privateKey, publicKey, new ASN1ObjectIdentifier(string2));
            jceKeyAgreeRecipientInfoGenerator.addRecipient(x509Certificate);
            if (provider != null) {
                jceKeyAgreeRecipientInfoGenerator.setProvider(provider);
            }
            this.fact.addRecipientInfoGenerator(jceKeyAgreeRecipientInfoGenerator);
            return;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new NoSuchAlgorithmException("cannot set up generator: " + certificateEncodingException);
        }
    }

    public void setBerEncodeRecipients(boolean bl2) {
        this.fact.setBEREncodeRecipients(bl2);
    }

    private j make(j j2, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        this.createSymmetricKeyGenerator(aSN1ObjectIdentifier.getId(), provider);
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, aSN1ObjectIdentifier, n2, provider), ENCRYPTED_CONTENT_TYPE);
            j3.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            j3.addHeader("Content-Description", "S/MIME Encrypted Message");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            return j3;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting S/MIME message together.", (Exception)((Object)q2));
        }
        catch (CMSException cMSException) {
            throw new SMIMEException("exception putting envelope together.", cMSException);
        }
    }

    private j make(j j2, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            j j3 = new j();
            j3.setContent((Object)new a(j2, outputEncryptor), ENCRYPTED_CONTENT_TYPE);
            j3.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            j3.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            j3.addHeader("Content-Description", "S/MIME Encrypted Message");
            j3.addHeader("Content-Transfer-Encoding", this.encoding);
            return j3;
        }
        catch (q q2) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)q2));
        }
    }

    public j generate(j j2, OutputEncryptor outputEncryptor) throws SMIMEException {
        return this.make(this.makeContentBodyPart(j2), outputEncryptor);
    }

    public j generate(k k2, OutputEncryptor outputEncryptor) throws SMIMEException {
        try {
            k2.b_();
        }
        catch (q q2) {
            throw new SMIMEException("unable to save message", (Exception)((Object)q2));
        }
        return this.make(this.makeContentBodyPart(k2), outputEncryptor);
    }

    public j generate(j j2, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(j2), new ASN1ObjectIdentifier(string), 0, SMIMEUtil.getProvider(string2));
    }

    public j generate(j j2, String string, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        return this.make(this.makeContentBodyPart(j2), new ASN1ObjectIdentifier(string), 0, provider);
    }

    public j generate(k k2, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(k2, string, SMIMEUtil.getProvider(string2));
    }

    public j generate(k k2, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            k2.b_();
        }
        catch (q q2) {
            throw new SMIMEException("unable to save message", (Exception)((Object)q2));
        }
        return this.make(this.makeContentBodyPart(k2), new ASN1ObjectIdentifier(string), 0, provider);
    }

    public j generate(j j2, String string, int n2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(j2, string, n2, SMIMEUtil.getProvider(string2));
    }

    public j generate(j j2, String string, int n2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(j2), new ASN1ObjectIdentifier(string), n2, provider);
    }

    public j generate(k k2, String string, int n2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(k2, string, n2, SMIMEUtil.getProvider(string2));
    }

    public j generate(k k2, String string, int n2, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            k2.b_();
        }
        catch (q q2) {
            throw new SMIMEException("unable to save message", (Exception)((Object)q2));
        }
        return this.make(this.makeContentBodyPart(k2), new ASN1ObjectIdentifier(string), n2, provider);
    }

    static {
        javax.activation.c.a((javax.activation.c)SMIMEEnvelopedGenerator.addCommands(javax.activation.c.a()));
    }

    private class a
    implements SMIMEStreamingProcessor {
        private final j b;
        private OutputEncryptor c;
        private boolean d = true;

        a(j j2, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, Provider provider) throws CMSException {
            this.b = j2;
            this.c = n2 == 0 ? new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier).setProvider(provider).build() : new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier, n2).setProvider(provider).build();
            if (provider != null) {
                for (RecipientInfoGenerator recipientInfoGenerator : SMIMEEnvelopedGenerator.this.recipients) {
                    if (recipientInfoGenerator instanceof JceKeyTransRecipientInfoGenerator) {
                        ((JceKeyTransRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                        continue;
                    }
                    if (!(recipientInfoGenerator instanceof JceKEKRecipientInfoGenerator)) continue;
                    ((JceKEKRecipientInfoGenerator)recipientInfoGenerator).setProvider(provider);
                }
            }
        }

        a(j j2, OutputEncryptor outputEncryptor) {
            this.b = j2;
            this.c = outputEncryptor;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            try {
                OutputStream outputStream2;
                if (this.d) {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.open(outputStream, this.c);
                    this.d = false;
                } else {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.a(outputStream, this.c);
                }
                this.b.getDataHandler().a((javax.activation.c)SMIMEEnvelopedGenerator.addCommands(javax.activation.c.a()));
                this.b.writeTo(outputStream2);
                outputStream2.close();
                return;
            }
            catch (q q2) {
                throw new c(q2.toString(), q2);
            }
            catch (CMSException cMSException) {
                throw new c(cMSException.toString(), cMSException);
            }
        }
    }

    private class b
    extends CMSEnvelopedDataStreamGenerator {
        private ASN1ObjectIdentifier b;
        private ASN1EncodableVector c;

        private b() {
        }

        @Override
        protected OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, ASN1EncodableVector aSN1EncodableVector, OutputEncryptor outputEncryptor) throws IOException {
            this.b = aSN1ObjectIdentifier;
            this.c = aSN1EncodableVector;
            return super.open(aSN1ObjectIdentifier, outputStream, aSN1EncodableVector, outputEncryptor);
        }

        OutputStream a(OutputStream outputStream, OutputEncryptor outputEncryptor) throws IOException {
            return super.open(this.b, outputStream, this.c, outputEncryptor);
        }
    }

    private static class c
    extends IOException {
        private Throwable a;

        c(String string, Throwable throwable) {
            super(string);
            this.a = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.a;
        }
    }
}

