/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageSigner;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.Layer;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowSigner
implements MessageSigner {
    private SecureRandom random;
    int signableDocumentLength;
    private short[] x;
    private ComputeInField cf = new ComputeInField();
    RainbowKeyParameters key;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (RainbowPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (RainbowPrivateKeyParameters)param;
            }
        } else {
            this.key = (RainbowPublicKeyParameters)param;
        }
        this.signableDocumentLength = this.key.getDocLength();
    }

    private short[] initSign(Layer[] layer, short[] msg) {
        short[] tmpVec = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB1(), msg);
        short[] Y_ = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA1(), tmpVec);
        for (int i2 = 0; i2 < layer[0].getVi(); ++i2) {
            this.x[i2] = (short)this.random.nextInt();
            this.x[i2] = (short)(this.x[i2] & 0xFF);
        }
        return Y_;
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        boolean ok;
        Layer[] layer = ((RainbowPrivateKeyParameters)this.key).getLayers();
        int numberOfLayers = layer.length;
        this.x = new short[((RainbowPrivateKeyParameters)this.key).getInvA2().length];
        byte[] S = new byte[layer[numberOfLayers - 1].getViNext()];
        short[] msgHashVals = this.makeMessageRepresentative(message);
        do {
            ok = true;
            int counter = 0;
            try {
                int i2;
                short[] Y_ = this.initSign(layer, msgHashVals);
                for (i2 = 0; i2 < numberOfLayers; ++i2) {
                    short[] y_i = new short[layer[i2].getOi()];
                    layer[i2].getOi();
                    for (int k2 = 0; k2 < layer[i2].getOi(); ++k2) {
                        y_i[k2] = Y_[counter];
                        ++counter;
                    }
                    short[] solVec = this.cf.solveEquation(layer[i2].plugInVinegars(this.x), y_i);
                    if (solVec == null) {
                        throw new Exception("LES is not solveable!");
                    }
                    for (int j2 = 0; j2 < solVec.length; ++j2) {
                        this.x[layer[i2].getVi() + j2] = solVec[j2];
                    }
                }
                short[] tmpVec = this.cf.addVect(((RainbowPrivateKeyParameters)this.key).getB2(), this.x);
                short[] signature = this.cf.multiplyMatrix(((RainbowPrivateKeyParameters)this.key).getInvA2(), tmpVec);
                for (i2 = 0; i2 < S.length; ++i2) {
                    S[i2] = (byte)signature[i2];
                }
            }
            catch (Exception exception) {
                ok = false;
            }
        } while (!ok);
        return S;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        short[] sigInt = new short[signature.length];
        for (int i2 = 0; i2 < signature.length; ++i2) {
            short tmp = signature[i2];
            sigInt[i2] = tmp = (short)(tmp & 0xFF);
        }
        short[] msgHashVal = this.makeMessageRepresentative(message);
        short[] verificationResult = this.verifySignatureIntern(sigInt);
        boolean verified = true;
        if (msgHashVal.length != verificationResult.length) {
            return false;
        }
        for (int i3 = 0; i3 < msgHashVal.length; ++i3) {
            verified = verified && msgHashVal[i3] == verificationResult[i3];
        }
        return verified;
    }

    private short[] verifySignatureIntern(short[] signature) {
        short[][] coeff_quadratic = ((RainbowPublicKeyParameters)this.key).getCoeffQuadratic();
        short[][] coeff_singular = ((RainbowPublicKeyParameters)this.key).getCoeffSingular();
        short[] coeff_scalar = ((RainbowPublicKeyParameters)this.key).getCoeffScalar();
        short[] rslt = new short[coeff_quadratic.length];
        int n2 = coeff_singular[0].length;
        for (int p2 = 0; p2 < coeff_quadratic.length; ++p2) {
            int offset = 0;
            for (int x2 = 0; x2 < n2; ++x2) {
                short tmp;
                for (int y2 = x2; y2 < n2; ++y2) {
                    tmp = GF2Field.multElem(coeff_quadratic[p2][offset], GF2Field.multElem(signature[x2], signature[y2]));
                    rslt[p2] = GF2Field.addElem(rslt[p2], tmp);
                    ++offset;
                }
                tmp = GF2Field.multElem(coeff_singular[p2][x2], signature[x2]);
                rslt[p2] = GF2Field.addElem(rslt[p2], tmp);
            }
            rslt[p2] = GF2Field.addElem(rslt[p2], coeff_scalar[p2]);
        }
        return rslt;
    }

    private short[] makeMessageRepresentative(byte[] message) {
        short[] output = new short[this.signableDocumentLength];
        int h2 = 0;
        int i2 = 0;
        while (i2 < message.length) {
            output[i2] = message[h2];
            int n2 = i2++;
            output[n2] = (short)(output[n2] & 0xFF);
            ++h2;
            if (i2 < output.length) continue;
        }
        return output;
    }
}

