/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.util.Store;
import com.timevale.tgtext.bouncycastle.x509.PKIXAttrCertChecker;
import com.timevale.tgtext.bouncycastle.x509.X509CertStoreSelector;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ExtendedPKIXParameters
extends PKIXParameters {
    private List stores = new ArrayList();
    private Selector selector;
    private boolean additionalLocationsEnabled;
    private List additionalStores = new ArrayList();
    private Set trustedACIssuers = new HashSet();
    private Set necessaryACAttributes = new HashSet();
    private Set prohibitedACAttributes = new HashSet();
    private Set attrCertCheckers = new HashSet();
    public static final int PKIX_VALIDITY_MODEL = 0;
    public static final int CHAIN_VALIDITY_MODEL = 1;
    private int validityModel = 0;
    private boolean useDeltas = false;

    public ExtendedPKIXParameters(Set trustAnchors) throws InvalidAlgorithmParameterException {
        super(trustAnchors);
    }

    public static ExtendedPKIXParameters getInstance(PKIXParameters pkixParams) {
        ExtendedPKIXParameters params;
        try {
            params = new ExtendedPKIXParameters((Set)pkixParams.getTrustAnchors());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
        params.setParams(pkixParams);
        return params;
    }

    protected void setParams(PKIXParameters params) {
        this.setDate(params.getDate());
        this.setCertPathCheckers(params.getCertPathCheckers());
        this.setCertStores((List)params.getCertStores());
        this.setAnyPolicyInhibited(params.isAnyPolicyInhibited());
        this.setExplicitPolicyRequired(params.isExplicitPolicyRequired());
        this.setPolicyMappingInhibited(params.isPolicyMappingInhibited());
        this.setRevocationEnabled(params.isRevocationEnabled());
        this.setInitialPolicies(params.getInitialPolicies());
        this.setPolicyQualifiersRejected(params.getPolicyQualifiersRejected());
        this.setSigProvider(params.getSigProvider());
        this.setTargetCertConstraints(params.getTargetCertConstraints());
        try {
            this.setTrustAnchors(params.getTrustAnchors());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
        if (params instanceof ExtendedPKIXParameters) {
            ExtendedPKIXParameters _params = (ExtendedPKIXParameters)params;
            this.validityModel = _params.validityModel;
            this.useDeltas = _params.useDeltas;
            this.additionalLocationsEnabled = _params.additionalLocationsEnabled;
            this.selector = _params.selector == null ? null : (Selector)_params.selector.clone();
            this.stores = new ArrayList(_params.stores);
            this.additionalStores = new ArrayList(_params.additionalStores);
            this.trustedACIssuers = new HashSet(_params.trustedACIssuers);
            this.prohibitedACAttributes = new HashSet(_params.prohibitedACAttributes);
            this.necessaryACAttributes = new HashSet(_params.necessaryACAttributes);
            this.attrCertCheckers = new HashSet(_params.attrCertCheckers);
        }
    }

    public boolean isUseDeltasEnabled() {
        return this.useDeltas;
    }

    public void setUseDeltasEnabled(boolean useDeltas) {
        this.useDeltas = useDeltas;
    }

    public int getValidityModel() {
        return this.validityModel;
    }

    public void setCertStores(List stores) {
        if (stores != null) {
            Iterator it = stores.iterator();
            while (it.hasNext()) {
                this.addCertStore((CertStore)it.next());
            }
        }
    }

    public void setStores(List stores) {
        if (stores == null) {
            this.stores = new ArrayList();
            return;
        }
        Iterator i2 = stores.iterator();
        while (i2.hasNext()) {
            if (i2.next() instanceof Store) continue;
            throw new ClassCastException("All elements of list must be of type org.bouncycastle.util.Store.");
        }
        this.stores = new ArrayList(stores);
    }

    public void addStore(Store store) {
        if (store != null) {
            this.stores.add(store);
        }
    }

    public void addAdditionalStore(Store store) {
        if (store != null) {
            this.additionalStores.add(store);
        }
    }

    public void addAddionalStore(Store store) {
        this.addAdditionalStore(store);
    }

    public List getAdditionalStores() {
        return Collections.unmodifiableList(this.additionalStores);
    }

    public List getStores() {
        return Collections.unmodifiableList(new ArrayList(this.stores));
    }

    public void setValidityModel(int validityModel) {
        this.validityModel = validityModel;
    }

    @Override
    public Object clone() {
        ExtendedPKIXParameters params;
        try {
            params = new ExtendedPKIXParameters((Set)this.getTrustAnchors());
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
        params.setParams(this);
        return params;
    }

    public boolean isAdditionalLocationsEnabled() {
        return this.additionalLocationsEnabled;
    }

    public void setAdditionalLocationsEnabled(boolean enabled) {
        this.additionalLocationsEnabled = enabled;
    }

    public Selector getTargetConstraints() {
        if (this.selector != null) {
            return (Selector)this.selector.clone();
        }
        return null;
    }

    public void setTargetConstraints(Selector selector) {
        if (selector != null) {
            this.selector = (Selector)selector.clone();
            return;
        }
        this.selector = null;
    }

    @Override
    public void setTargetCertConstraints(CertSelector selector) {
        super.setTargetCertConstraints(selector);
        if (selector != null) {
            this.selector = X509CertStoreSelector.getInstance((X509CertSelector)selector);
            return;
        }
        this.selector = null;
    }

    public Set getTrustedACIssuers() {
        return Collections.unmodifiableSet(this.trustedACIssuers);
    }

    public void setTrustedACIssuers(Set trustedACIssuers) {
        if (trustedACIssuers == null) {
            this.trustedACIssuers.clear();
            return;
        }
        Iterator it = trustedACIssuers.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("All elements of set must be of type " + TrustAnchor.class.getName() + ".");
        }
        this.trustedACIssuers.clear();
        this.trustedACIssuers.addAll(trustedACIssuers);
    }

    public Set getNecessaryACAttributes() {
        return Collections.unmodifiableSet(this.necessaryACAttributes);
    }

    public void setNecessaryACAttributes(Set necessaryACAttributes) {
        if (necessaryACAttributes == null) {
            this.necessaryACAttributes.clear();
            return;
        }
        Iterator it = necessaryACAttributes.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.necessaryACAttributes.clear();
        this.necessaryACAttributes.addAll(necessaryACAttributes);
    }

    public Set getProhibitedACAttributes() {
        return Collections.unmodifiableSet(this.prohibitedACAttributes);
    }

    public void setProhibitedACAttributes(Set prohibitedACAttributes) {
        if (prohibitedACAttributes == null) {
            this.prohibitedACAttributes.clear();
            return;
        }
        Iterator it = prohibitedACAttributes.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof String) continue;
            throw new ClassCastException("All elements of set must be of type String.");
        }
        this.prohibitedACAttributes.clear();
        this.prohibitedACAttributes.addAll(prohibitedACAttributes);
    }

    public Set getAttrCertCheckers() {
        return Collections.unmodifiableSet(this.attrCertCheckers);
    }

    public void setAttrCertCheckers(Set attrCertCheckers) {
        if (attrCertCheckers == null) {
            this.attrCertCheckers.clear();
            return;
        }
        Iterator it = attrCertCheckers.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof PKIXAttrCertChecker) continue;
            throw new ClassCastException("All elements of set must be of type " + PKIXAttrCertChecker.class.getName() + ".");
        }
        this.attrCertCheckers.clear();
        this.attrCertCheckers.addAll(attrCertCheckers);
    }
}

