/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.agreement;

import com.timevale.tgtext.bouncycastle.crypto.BasicAgreement;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECDomainParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = pub.getParameters();
        ECPoint P = pub.getQ().multiply(params.getH().multiply(this.key.getD()));
        return P.getX().toBigInteger();
    }
}

