/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttCertValidityPeriod;
import com.timevale.tgtext.bouncycastle.asn1.x509.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificateInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateIssuer;
import com.timevale.tgtext.bouncycastle.cert.CertException;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import com.timevale.tgtext.bouncycastle.cert.a;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509AttributeCertificateHolder {
    private static Attribute[] EMPTY_ARRAY = new Attribute[0];
    private AttributeCertificate attrCert;
    private Extensions extensions;

    private static AttributeCertificate parseBytes(byte[] certEncoding) throws IOException {
        try {
            return AttributeCertificate.getInstance(ASN1Primitive.fromByteArray(certEncoding));
        }
        catch (ClassCastException e2) {
            throw new CertIOException("malformed data: " + e2.getMessage(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw new CertIOException("malformed data: " + e3.getMessage(), e3);
        }
    }

    public X509AttributeCertificateHolder(byte[] certEncoding) throws IOException {
        this(X509AttributeCertificateHolder.parseBytes(certEncoding));
    }

    public X509AttributeCertificateHolder(AttributeCertificate attrCert) {
        this.attrCert = attrCert;
        this.extensions = attrCert.getAcinfo().getExtensions();
    }

    public byte[] getEncoded() throws IOException {
        return this.attrCert.getEncoded();
    }

    public int getVersion() {
        return this.attrCert.getAcinfo().getVersion().getValue().intValue() + 1;
    }

    public BigInteger getSerialNumber() {
        return this.attrCert.getAcinfo().getSerialNumber().getValue();
    }

    public AttributeCertificateHolder getHolder() {
        return new AttributeCertificateHolder((ASN1Sequence)this.attrCert.getAcinfo().getHolder().toASN1Primitive());
    }

    public AttributeCertificateIssuer getIssuer() {
        return new AttributeCertificateIssuer(this.attrCert.getAcinfo().getIssuer());
    }

    public Date getNotBefore() {
        return a.a(this.attrCert.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime());
    }

    public Date getNotAfter() {
        return a.a(this.attrCert.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime());
    }

    public Attribute[] getAttributes() {
        ASN1Sequence seq = this.attrCert.getAcinfo().getAttributes();
        Attribute[] attrs = new Attribute[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            attrs[i2] = Attribute.getInstance(seq.getObjectAt(i2));
        }
        return attrs;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier type) {
        ASN1Sequence seq = this.attrCert.getAcinfo().getAttributes();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            Attribute attr = Attribute.getInstance(seq.getObjectAt(i2));
            if (!attr.getAttrType().equals(type)) continue;
            list.add(attr);
        }
        if (list.size() == 0) {
            return EMPTY_ARRAY;
        }
        return list.toArray(new Attribute[list.size()]);
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public List getExtensionOIDs() {
        return a.c(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return a.a(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return a.b(this.extensions);
    }

    public boolean[] getIssuerUniqueID() {
        return a.a(this.attrCert.getAcinfo().getIssuerUniqueID());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.attrCert.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.attrCert.getSignatureValue().getBytes();
    }

    public AttributeCertificate toASN1Structure() {
        return this.attrCert;
    }

    public boolean isValidOn(Date date) {
        AttCertValidityPeriod certValidityPeriod = this.attrCert.getAcinfo().getAttrCertValidityPeriod();
        return !date.before(a.a(certValidityPeriod.getNotBeforeTime())) && !date.after(a.a(certValidityPeriod.getNotAfterTime()));
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws CertException {
        ContentVerifier verifier;
        AttributeCertificateInfo acinfo = this.attrCert.getAcinfo();
        if (!a.a(acinfo.getSignature(), this.attrCert.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            verifier = verifierProvider.get(acinfo.getSignature());
            OutputStream sOut = verifier.getOutputStream();
            DEROutputStream dOut = new DEROutputStream(sOut);
            dOut.writeObject(acinfo);
            sOut.close();
        }
        catch (Exception e2) {
            throw new CertException("unable to process signature: " + e2.getMessage(), e2);
        }
        return verifier.verify(this.attrCert.getSignatureValue().getBytes());
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof X509AttributeCertificateHolder)) {
            return false;
        }
        X509AttributeCertificateHolder other = (X509AttributeCertificateHolder)o2;
        return this.attrCert.equals(other.attrCert);
    }

    public int hashCode() {
        return this.attrCert.hashCode();
    }
}

