/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs;

import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.SafeBag;
import com.timevale.tgtext.bouncycastle.cms.CMSEncryptedData;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.operator.InputDecryptorProvider;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12SafeBag;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo info) {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(info.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(com.timevale.tgtext.bouncycastle.asn1.pkcs.ContentInfo info, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData encData = new CMSEncryptedData(ContentInfo.getInstance(info));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(encData.getContent(inputDecryptorProvider));
                return;
            }
            catch (CMSException e2) {
                throw new PKCSException("unable to extract data: " + e2.getMessage(), e2);
            }
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] safeBags = new PKCS12SafeBag[this.safeBagSeq.size()];
        for (int i2 = 0; i2 != this.safeBagSeq.size(); ++i2) {
            safeBags[i2] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i2)));
        }
        return safeBags;
    }
}

