/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.template.creater;

import com.timevale.seal.graphics.GraphicsOutput;
import com.timevale.seal.graphics.GraphicsTool;
import com.timevale.seal.graphics.seal.OfficialSealCentral;
import com.timevale.seal.graphics.seal.a;
import com.timevale.seal.template.creater.GraphicsOfficialSeal;
import com.timevale.seal.template.creater.OfficialSealTemplate;
import com.timevale.seal.template.loader.OfficialSealTemplatePolicyLoader;
import com.timevale.seal.template.tools.Stamp;
import esign.utils.exception.aj;
import esign.utils.s;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;

public class SealImageCreater {
    private static final IndexColorModel icm = GraphicsTool.CM_SEAL;
    private OfficialSealTemplatePolicyLoader loader = new OfficialSealTemplatePolicyLoader();
    private Stamp stamp = new Stamp();
    private int nameOffset = 110;
    private int width = 480;
    private int height = 480;
    private float radius = 86.0f;
    private float firmAngle = 120.0f;
    private String name;
    private Color nameColor = Color.RED;
    private String firm;
    private Color firmColor = Color.RED;
    private Font nameFont = this.stamp.a("simsun", 40);
    private Font firmFont = null;
    private int firmFontSize = 60;
    private int firmFontWidth;
    private float firmScale = 0.7f;
    private float borderWidth = 14.2f;
    private Color borderColor = Color.RED;
    private float signBorderWidth = 5.0f;
    private Color signBorderColor = Color.RED;
    private Color signFillColor = Color.RED;
    private String sealType;
    private String rune;
    private esign.utils.constant.type.Color globalColor = esign.utils.constant.type.Color.RED;

    static IndexColorModel createIndexColorModel() {
        BufferedImage ex = new BufferedImage(1, 1, 13);
        IndexColorModel icm = (IndexColorModel)ex.getColorModel();
        byte[] r2 = new byte[256];
        byte[] g2 = new byte[256];
        byte[] b2 = new byte[256];
        byte[] a2 = new byte[256];
        icm.getReds(r2);
        icm.getGreens(g2);
        icm.getBlues(b2);
        Arrays.fill(a2, (byte)-1);
        a2[0] = 0;
        b2[0] = -1;
        g2[0] = -1;
        r2[0] = -1;
        return new IndexColorModel(8, 256, r2, g2, b2, a2);
    }

    public void draw(Graphics2D g2d) {
        float x2;
        double radians;
        float a2;
        int cw;
        char c2;
        int i2;
        int var23;
        g2d.translate(this.width / 2, this.height / 2);
        Stroke stroke = g2d.getStroke();
        if (s.c(this.sealType, "star")) {
            Polygon fm = this.getPentaclePoints(this.radius);
            if (this.signFillColor != null) {
                g2d.setColor(this.signFillColor);
                g2d.fill(fm);
            }
            g2d.setStroke(new BasicStroke(this.signBorderWidth));
            g2d.setColor(this.signBorderColor);
            g2d.draw(fm);
        } else if (!s.c(this.sealType, "oval")) {
            try {
                this.getClass().getClassLoader().getResource("/images");
                String path = URLDecoder.decode(this.getClass().getClassLoader().getResource("").getFile(), "UTF-8");
                File h2 = new File(path + this.sealType + ".png");
                if (!h2.exists()) {
                    h2.createNewFile();
                }
                FileInputStream count = new FileInputStream(h2);
                BufferedImage r2 = ImageIO.read(count);
                g2d.drawImage((Image)r2, -85, -100, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                FileNotFoundException var19 = fileNotFoundException;
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                IOException var20 = iOException;
                iOException.printStackTrace();
            }
        }
        g2d.setColor(this.borderColor);
        g2d.setStroke(new BasicStroke(this.borderWidth));
        g2d.drawOval(-this.width / 2, -this.height / 2, this.width, this.height);
        g2d.setStroke(stroke);
        g2d.setFont(this.nameFont);
        g2d.setColor(this.nameColor);
        FontMetrics var22 = g2d.getFontMetrics();
        if (this.name != null && !this.name.trim().equals("")) {
            int var24 = var22.stringWidth(this.name);
            var23 = var22.getHeight() - 20;
            int var25 = var22.getAscent() - var23 / 2;
            g2d.scale(0.6, 1.0);
            g2d.drawString(this.name, -var24 / 2, var25 + this.nameOffset);
            g2d.scale(1.6666666666666667, 1.0);
        }
        this.firmFont = this.stamp.a("simsun", this.firmFontSize);
        g2d.setFont(this.firmFont);
        g2d.setColor(this.firmColor);
        var22 = g2d.getFontMetrics();
        var23 = var22.getHeight() + 20;
        int var24 = this.firm.length();
        int var25 = this.width / 2 + this.firmFontWidth;
        float angle = (300.0f - this.firmAngle) / (float)(var24 - 1);
        float start = 120.0f + this.firmAngle / 2.0f;
        double vr = Math.toRadians(90.0);
        char[] chars = this.firm.toCharArray();
        for (i2 = 0; i2 < var24; ++i2) {
            c2 = chars[i2];
            cw = var22.charWidth(c2);
            a2 = start + angle * (float)i2;
            radians = Math.toRadians(a2);
            g2d.rotate(radians);
            x2 = var25 - var23;
            g2d.translate(x2, 0.0);
            g2d.rotate(vr);
            g2d.scale(this.firmScale, 1.0);
            g2d.drawString(String.valueOf(c2), -cw / 2, 0);
            g2d.scale(1.0f / this.firmScale, 1.0);
            g2d.rotate(-vr);
            g2d.translate(-x2, 0.0);
            g2d.rotate(-radians);
        }
        if (!s.a(this.rune)) {
            this.rune = SealImageCreater.reverseString(this.rune);
            this.firmFont = this.stamp.a("simsun", this.firmFontSize / 2);
            g2d.setFont(this.firmFont);
            g2d.setColor(this.firmColor);
            var22 = g2d.getFontMetrics();
            var23 = var22.getHeight();
            var24 = this.rune.length();
            var25 = this.width / 2 + this.firmFontWidth;
            if (this.rune.length() == 1) {
                angle = 0.0f;
                start = 90.0f;
            } else {
                angle = (40.0f + this.firmAngle) / (float)(var24 - 1);
                start = 40.0f + (60.0f - this.firmAngle) / 2.0f;
            }
            vr = Math.toRadians(270.0);
            chars = this.rune.toCharArray();
            for (i2 = 0; i2 < var24; ++i2) {
                c2 = chars[i2];
                cw = var22.charWidth(c2);
                a2 = start + angle * (float)i2;
                radians = Math.toRadians(a2);
                g2d.rotate(radians);
                x2 = var25 - var23;
                g2d.translate(x2, 0.0);
                g2d.rotate(vr);
                g2d.scale(this.firmScale, 1.0);
                g2d.drawString(String.valueOf(c2), -cw / 2, 0);
                g2d.scale(1.0f / this.firmScale, 1.0);
                g2d.rotate(-vr);
                g2d.translate(-x2, 0.0);
                g2d.rotate(-radians);
            }
        }
    }

    private Polygon getPentaclePoints(float radius) {
        if (radius <= 0.0f) {
            return null;
        }
        float lradius = radius * 0.381966f;
        Point[] points = new Point[10];
        for (int polygon = 0; polygon < 10; ++polygon) {
            points[polygon] = polygon % 2 == 1 ? new Point((int)(Math.sin(0.6283185307179586 * (double)polygon) * (double)radius), (int)(Math.cos(0.6283185307179586 * (double)polygon) * (double)radius)) : new Point((int)(Math.sin(0.6283185307179586 * (double)polygon) * (double)lradius), (int)(Math.cos(0.6283185307179586 * (double)polygon) * (double)lradius));
        }
        Polygon var11 = new Polygon();
        Point[] arr$ = points;
        for (int i$ = 0; i$ < 10; ++i$) {
            Point p2 = arr$[i$];
            var11.addPoint(p2.x, p2.y);
        }
        return var11;
    }

    public static String reverseString(String str) {
        StringBuffer sbf = new StringBuffer();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            sbf.insert(0, str.charAt(i2));
        }
        return sbf.toString();
    }

    public static Color parseToColor(String c2) throws NumberFormatException {
        return new Color(Integer.parseInt(c2, 16));
    }

    public BufferedImage export2img() throws IOException, aj {
        if (StringUtils.isEmpty((String)this.rune) && StringUtils.isEmpty((String)this.name)) {
            this.loader.loadDefault();
            a fix1 = new a();
            fix1.a(this.globalColor);
            fix1.a(this.firm);
            fix1.a(OfficialSealCentral.from(this.sealType));
            OfficialSealTemplate bi1 = this.loader.select(this.firm.length());
            GraphicsOfficialSeal g2d1 = new GraphicsOfficialSeal(bi1);
            GraphicsOutput output = g2d1.render(fix1);
            return output.image();
        }
        BufferedImage bi = new BufferedImage(this.getWidth() + 16, this.getHeight() + 16, 13, icm);
        Graphics2D g2d = bi.createGraphics();
        g2d.translate(8, 8);
        this.draw(g2d);
        g2d.dispose();
        return bi;
    }

    public byte[] export2pic() throws IOException {
        BufferedImage bi = new BufferedImage(this.getWidth() + 16, this.getHeight() + 16, 13, icm);
        Graphics2D g2d = bi.createGraphics();
        g2d.translate(8, 8);
        this.draw(g2d);
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", baos);
        return baos.toByteArray();
    }

    public static InputStream scale(String srcImageFile, int newWidth, int newHeight) throws IOException {
        BufferedImage src = ImageIO.read(new File(srcImageFile));
        Image image = src.getScaledInstance(newWidth, newHeight, 1);
        BufferedImage tag = new BufferedImage(newWidth, newHeight, 13, icm);
        Graphics2D g2d = tag.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)tag, "png", baos);
        ByteArrayInputStream result = new ByteArrayInputStream(baos.toByteArray());
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public void setNameOffset(int nameOffset) {
        this.nameOffset = nameOffset;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getFirmAngle() {
        return this.firmAngle;
    }

    public void setFirmAngle(float firmAngle) {
        this.firmAngle = firmAngle;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getNameColor() {
        return this.nameColor;
    }

    public void setNameColor(Color nameColor) {
        this.nameColor = nameColor;
    }

    public String getFirm() {
        return this.firm;
    }

    public void setFirm(String firm) {
        this.firm = firm;
    }

    public Color getFirmColor() {
        return this.firmColor;
    }

    public void setFirmColor(Color firmColor) {
        this.firmColor = firmColor;
    }

    public Font getNameFont() {
        return this.nameFont;
    }

    public void setNameFont(Font nameFont) {
        this.nameFont = nameFont;
    }

    public Font getFirmFont() {
        return this.firmFont;
    }

    public void setFirmFont(Font firmFont) {
        this.firmFont = firmFont;
    }

    public float getFirmScale() {
        return this.firmScale;
    }

    public void setFirmScale(float firmScale) {
        this.firmScale = firmScale;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getSignBorderWidth() {
        return this.signBorderWidth;
    }

    public void setSignBorderWidth(float signBorderWidth) {
        this.signBorderWidth = signBorderWidth;
    }

    public Color getSignBorderColor() {
        return this.signBorderColor;
    }

    public void setSignBorderColor(Color signBorderColor) {
        this.signBorderColor = signBorderColor;
    }

    public Color getSignFillColor() {
        return this.signFillColor;
    }

    public void setSignFillColor(Color signFillColor) {
        this.signFillColor = signFillColor;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getFirmFontSize() {
        return this.firmFontSize;
    }

    public void setFirmFontSize(int firmFontSize) {
        this.firmFontSize = firmFontSize;
    }

    public int getFirmFontWidth() {
        return this.firmFontWidth;
    }

    public void setFirmFontWidth(int firmFontWidth) {
        this.firmFontWidth = firmFontWidth;
    }

    public String getRune() {
        return this.rune;
    }

    public void setRune(String rune) {
        this.rune = rune;
    }

    public String getSealType() {
        return this.sealType;
    }

    public void setSealType(String sealType) {
        this.sealType = sealType;
        if (s.a(this.sealType)) {
            this.sealType = "";
        }
    }

    public void setGlobalColor(esign.utils.constant.type.Color color) {
        this.globalColor = color;
        this.setBorderColor(color.getAwtColor());
        this.setFirmColor(color.getAwtColor());
        this.setNameColor(color.getAwtColor());
        this.setSignBorderColor(color.getAwtColor());
        this.setSignFillColor(color.getAwtColor());
    }
}

