/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.crmf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Choice;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cms.EnvelopedData;
import com.timevale.tgtext.bouncycastle.asn1.crmf.PKMACValue;
import com.timevale.tgtext.bouncycastle.asn1.crmf.SubsequentMessage;

public class POPOPrivKey
extends ASN1Object
implements ASN1Choice {
    public static final int thisMessage = 0;
    public static final int subsequentMessage = 1;
    public static final int dhMAC = 2;
    public static final int agreeMAC = 3;
    public static final int encryptedKey = 4;
    private int tagNo;
    private ASN1Encodable obj;

    private POPOPrivKey(ASN1TaggedObject obj) {
        this.tagNo = obj.getTagNo();
        switch (this.tagNo) {
            case 0: {
                this.obj = DERBitString.getInstance(obj, false);
                return;
            }
            case 1: {
                this.obj = SubsequentMessage.valueOf(ASN1Integer.getInstance(obj, false).getValue().intValue());
                return;
            }
            case 2: {
                this.obj = DERBitString.getInstance(obj, false);
                return;
            }
            case 3: {
                this.obj = PKMACValue.getInstance(obj, false);
                return;
            }
            case 4: {
                this.obj = EnvelopedData.getInstance(obj, false);
                return;
            }
        }
        throw new IllegalArgumentException("unknown tag in POPOPrivKey");
    }

    public static POPOPrivKey getInstance(Object obj) {
        if (obj instanceof POPOPrivKey) {
            return (POPOPrivKey)obj;
        }
        if (obj != null) {
            return new POPOPrivKey(ASN1TaggedObject.getInstance(obj));
        }
        return null;
    }

    public static POPOPrivKey getInstance(ASN1TaggedObject obj, boolean explicit) {
        return POPOPrivKey.getInstance(ASN1TaggedObject.getInstance(obj, explicit));
    }

    public POPOPrivKey(SubsequentMessage msg) {
        this.tagNo = 1;
        this.obj = msg;
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getValue() {
        return this.obj;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.tagNo, this.obj);
    }
}

