/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.timevale.tgtext.bouncycastle.asn1.sec.ECPrivateKey;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.DSAParameter;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.jce.ECNamedCurveTable;
import com.timevale.tgtext.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import com.timevale.tgtext.bouncycastle.openssl.PEMEncryptedKeyPair;
import com.timevale.tgtext.bouncycastle.openssl.PEMException;
import com.timevale.tgtext.bouncycastle.openssl.PEMKeyPair;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemHeader;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObject;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObjectParser;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PEMParser
extends PemReader {
    private final Map parsers = new HashMap();

    public PEMParser(Reader reader) {
        super(reader);
        this.parsers.put("CERTIFICATE REQUEST", new f());
        this.parsers.put("NEW CERTIFICATE REQUEST", new f());
        this.parsers.put("CERTIFICATE", new n());
        this.parsers.put("X509 CERTIFICATE", new n());
        this.parsers.put("X509 CRL", new m());
        this.parsers.put("PKCS7", new g());
        this.parsers.put("ATTRIBUTE CERTIFICATE", new l());
        this.parsers.put("EC PARAMETERS", new c());
        this.parsers.put("PUBLIC KEY", new i());
        this.parsers.put("RSA PUBLIC KEY", new k());
        this.parsers.put("RSA PRIVATE KEY", new e(new j()));
        this.parsers.put("DSA PRIVATE KEY", new e(new a()));
        this.parsers.put("EC PRIVATE KEY", new e(new b()));
        this.parsers.put("ENCRYPTED PRIVATE KEY", new d());
        this.parsers.put("PRIVATE KEY", new h());
    }

    public Object readObject() throws IOException {
        PemObject obj = this.readPemObject();
        if (obj != null) {
            String type = obj.getType();
            if (this.parsers.containsKey(type)) {
                return ((PemObjectParser)this.parsers.get(type)).parseObject(obj);
            }
            throw new IOException("unrecognised object: " + type);
        }
        return null;
    }

    private class h
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return PrivateKeyInfo.getInstance(obj.getContent());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing PRIVATE KEY: " + e2.toString(), e2);
            }
        }
    }

    private class d
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(obj.getContent()));
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + e2.toString(), e2);
            }
        }
    }

    private class c
    implements PemObjectParser {
        private c() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                DERObjectIdentifier oid = (DERObjectIdentifier)ASN1Primitive.fromByteArray(obj.getContent());
                ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec(oid.getId());
                if (params == null) {
                    throw new IOException("object ID not found in EC curve table");
                }
                return params;
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("exception extracting EC named curve: " + e3.toString());
            }
        }
    }

    private class l
    implements PemObjectParser {
        private l() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            return new X509AttributeCertificateHolder(obj.getContent());
        }
    }

    private class g
    implements PemObjectParser {
        private g() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                ASN1InputStream aIn = new ASN1InputStream(obj.getContent());
                return ContentInfo.getInstance(aIn.readObject());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing PKCS7 object: " + e2.toString(), e2);
            }
        }
    }

    private class f
    implements PemObjectParser {
        private f() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new PKCS10CertificationRequest(obj.getContent());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing certrequest: " + e2.toString(), e2);
            }
        }
    }

    private class m
    implements PemObjectParser {
        private m() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CRLHolder(obj.getContent());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing cert: " + e2.toString(), e2);
            }
        }
    }

    private class n
    implements PemObjectParser {
        private n() {
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                return new X509CertificateHolder(obj.getContent());
            }
            catch (Exception e2) {
                throw new PEMException("problem parsing cert: " + e2.toString(), e2);
            }
        }
    }

    private class k
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            try {
                RSAPublicKey rsaPubStructure = RSAPublicKey.getInstance(obj.getContent());
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), rsaPubStructure);
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem extracting key: " + e3.toString(), e3);
            }
        }
    }

    private class i
    implements PemObjectParser {
        @Override
        public Object parseObject(PemObject obj) throws IOException {
            return SubjectPublicKeyInfo.getInstance(obj.getContent());
        }
    }

    private class j
    implements com.timevale.tgtext.bouncycastle.openssl.a {
        private j() {
        }

        @Override
        public PEMKeyPair a(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey keyStruct = RSAPrivateKey.getInstance(seq);
                RSAPublicKey pubSpec = new RSAPublicKey(keyStruct.getModulus(), keyStruct.getPublicExponent());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
                return new PEMKeyPair(new SubjectPublicKeyInfo(algId, pubSpec), new PrivateKeyInfo(algId, keyStruct));
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating RSA private key: " + e3.toString(), e3);
            }
        }
    }

    private class b
    implements com.timevale.tgtext.bouncycastle.openssl.a {
        private b() {
        }

        @Override
        public PEMKeyPair a(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                ECPrivateKey pKey = ECPrivateKey.getInstance(seq);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
                PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, pKey);
                SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
                return new PEMKeyPair(pubInfo, privInfo);
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating EC private key: " + e3.toString(), e3);
            }
        }
    }

    private class a
    implements com.timevale.tgtext.bouncycastle.openssl.a {
        private a() {
        }

        @Override
        public PEMKeyPair a(byte[] encoding) throws IOException {
            try {
                ASN1Sequence seq = ASN1Sequence.getInstance(encoding);
                if (seq.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                ASN1Integer p2 = ASN1Integer.getInstance(seq.getObjectAt(1));
                ASN1Integer q2 = ASN1Integer.getInstance(seq.getObjectAt(2));
                ASN1Integer g2 = ASN1Integer.getInstance(seq.getObjectAt(3));
                ASN1Integer y2 = ASN1Integer.getInstance(seq.getObjectAt(4));
                ASN1Integer x2 = ASN1Integer.getInstance(seq.getObjectAt(5));
                return new PEMKeyPair(new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(p2.getValue(), q2.getValue(), g2.getValue())), y2), new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(p2.getValue(), q2.getValue(), g2.getValue())), x2));
            }
            catch (IOException iOException) {
                IOException e2 = iOException;
                throw iOException;
            }
            catch (Exception e3) {
                throw new PEMException("problem creating DSA private key: " + e3.toString(), e3);
            }
        }
    }

    private class e
    implements PemObjectParser {
        private final com.timevale.tgtext.bouncycastle.openssl.a b;

        public e(com.timevale.tgtext.bouncycastle.openssl.a pemKeyPairParser) {
            this.b = pemKeyPairParser;
        }

        @Override
        public Object parseObject(PemObject obj) throws IOException {
            boolean isEncrypted = false;
            String dekInfo = null;
            List headers = obj.getHeaders();
            for (PemHeader hdr : headers) {
                if (hdr.getName().equals("Proc-Type") && hdr.getValue().equals("4,ENCRYPTED")) {
                    isEncrypted = true;
                    continue;
                }
                if (!hdr.getName().equals("DEK-Info")) continue;
                dekInfo = hdr.getValue();
            }
            byte[] keyBytes = obj.getContent();
            try {
                if (isEncrypted) {
                    StringTokenizer tknz = new StringTokenizer(dekInfo, ",");
                    String dekAlgName = tknz.nextToken();
                    byte[] iv = Hex.decode(tknz.nextToken());
                    return new PEMEncryptedKeyPair(dekAlgName, iv, keyBytes, this.b);
                }
                return this.b.a(keyBytes);
            }
            catch (IOException e2) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e2);
                }
                throw new PEMException(e2.getMessage(), e2);
            }
            catch (IllegalArgumentException e3) {
                if (isEncrypted) {
                    throw new PEMException("exception decoding - please check password and data.", e3);
                }
                throw new PEMException(e3.getMessage(), e3);
            }
        }
    }
}

