/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.BEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.cms.AuthenticatedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSAuthenticatedData;
import com.timevale.tgtext.bouncycastle.cms.CMSAuthenticatedGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import com.timevale.tgtext.bouncycastle.cms.RecipientInfoGenerator;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.MacCalculator;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.util.io.TeeOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(typedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authData;
        ByteArrayOutputStream bOut;
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream out = new TeeOutputStream(digestCalculator.getOutputStream(), bOut);
                typedData.write(out);
                ((OutputStream)out).close();
                encContent = new BEROctetString(bOut.toByteArray());
            }
            catch (IOException e2) {
                throw new CMSException("unable to perform digest calculation: " + e2.getMessage(), e2);
            }
            Map parameters = this.getBaseParameters(typedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            DERSet authed = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector());
            try {
                OutputStream mOut = macCalculator.getOutputStream();
                mOut.write(authed.getEncoded("DER"));
                mOut.close();
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e3) {
                throw new CMSException("exception decoding algorithm parameters.", e3);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), eci, authed, macResult, unauthed);
        } else {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream mOut = new TeeOutputStream(bOut, macCalculator.getOutputStream());
                typedData.write(mOut);
                ((OutputStream)mOut).close();
                encContent = new BEROctetString(bOut.toByteArray());
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e4) {
                throw new CMSException("exception decoding algorithm parameters.", e4);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, encContent);
            authData = new AuthenticatedData(this.originatorInfo, new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), null, eci, null, macResult, unauthed);
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, authData);
        return new CMSAuthenticatedData(contentInfo, new DigestCalculatorProvider(){

            @Override
            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSAuthenticatedData generate(final CMSProcessable content, String macOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider encProvider = keyGen.getProvider();
        this.convertOldRecipients(this.rand, provider);
        return this.generate(new CMSTypedData(){

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return CMSObjectIdentifiers.data;
            }

            @Override
            public void write(OutputStream out) throws IOException, CMSException {
                content.write(out);
            }

            @Override
            public Object getContent() {
                return content;
            }
        }, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(macOID)).setProvider(encProvider).setSecureRandom(this.rand).build());
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String macOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, macOID, i.a(provider));
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = d.a.a(encryptionOID, provider);
        return this.generate(content, encryptionOID, keyGen, provider);
    }
}

