/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.util;

import com.timevale.tgtext.bouncycastle.crypto.Digest;

public class GMSSRandom {
    private Digest messDigestTree;

    public GMSSRandom(Digest messDigestTree2) {
        this.messDigestTree = messDigestTree2;
    }

    public byte[] nextSeed(byte[] outseed) {
        this.messDigestTree.update(outseed, 0, outseed.length);
        byte[] rand = new byte[this.messDigestTree.getDigestSize()];
        this.messDigestTree.doFinal(rand, 0);
        this.addByteArrays(outseed, rand);
        this.addOne(outseed);
        return rand;
    }

    private void addByteArrays(byte[] a2, byte[] b2) {
        int overflow = 0;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int temp = (0xFF & a2[i2]) + (0xFF & b2[i2]) + overflow;
            a2[i2] = (byte)temp;
            overflow = (byte)(temp >> 8);
        }
    }

    private void addOne(byte[] a2) {
        int overflow = 1;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            int temp = (0xFF & a2[i2]) + overflow;
            a2[i2] = (byte)temp;
            overflow = (byte)(temp >> 8);
        }
    }
}

