/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.util.encoders;

import com.timevale.tgtext.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i2;
        for (i2 = 0; i2 < this.decodingTable.length; ++i2) {
            this.decodingTable[i2] = -1;
        }
        for (i2 = 0; i2 < this.encodingTable.length; ++i2) {
            this.decodingTable[this.encodingTable[i2]] = (byte)i2;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        for (int i2 = off; i2 < off + length; ++i2) {
            int v2 = data[i2] & 0xFF;
            out.write(this.encodingTable[v2 >>> 4]);
            out.write(this.encodingTable[v2 & 0xF]);
        }
        return length << 1;
    }

    private static boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int end;
        int outLen = 0;
        for (end = off + length; end > off && HexEncoder.ignore((char)data[end - 1]); --end) {
        }
        int i2 = off;
        while (i2 < end) {
            byte b2;
            while (i2 < end && HexEncoder.ignore((char)data[i2])) {
                ++i2;
            }
            byte b1 = this.decodingTable[data[i2++]];
            while (i2 < end && HexEncoder.ignore((char)data[i2])) {
                ++i2;
            }
            if ((b1 | (b2 = this.decodingTable[data[i2++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            out.write(b1 << 4 | b2);
            ++outLen;
        }
        return outLen;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        int end;
        int length = 0;
        for (end = data.length(); end > 0 && HexEncoder.ignore(data.charAt(end - 1)); --end) {
        }
        int i2 = 0;
        while (i2 < end) {
            byte b2;
            while (i2 < end && HexEncoder.ignore(data.charAt(i2))) {
                ++i2;
            }
            byte b1 = this.decodingTable[data.charAt(i2++)];
            while (i2 < end && HexEncoder.ignore(data.charAt(i2))) {
                ++i2;
            }
            if ((b1 | (b2 = this.decodingTable[data.charAt(i2++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            out.write(b1 << 4 | b2);
            ++length;
        }
        return length;
    }
}

