/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GFElement;
import java.math.BigInteger;
import java.util.Random;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    public GF2nONBElement(GF2nONBField gf2n, Random rand) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            for (int j2 = 0; j2 < this.mLength - 1; ++j2) {
                this.mPol[j2] = rand.nextLong();
            }
            long last = rand.nextLong();
            this.mPol[this.mLength - 1] = last >>> 64 - this.mBit;
            return;
        }
        this.mPol[0] = rand.nextLong();
        this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
    }

    public GF2nONBElement(GF2nONBField gf2n, byte[] e2) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(e2);
    }

    public GF2nONBElement(GF2nONBField gf2n, BigInteger val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(val);
    }

    private GF2nONBElement(GF2nONBField gf2n, long[] val) {
        this.mField = gf2n;
        this.mDegree = this.mField.getDegree();
        this.mLength = gf2n.getONBLength();
        this.mBit = gf2n.getONBBit();
        this.mPol = val;
    }

    public GF2nONBElement(GF2nONBElement gf2n) {
        this.mField = gf2n.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gf2n.getElement());
    }

    @Override
    public Object clone() {
        return new GF2nONBElement(this);
    }

    public static GF2nONBElement ZERO(GF2nONBField gf2n) {
        long[] polynomial = new long[gf2n.getONBLength()];
        return new GF2nONBElement(gf2n, polynomial);
    }

    public static GF2nONBElement ONE(GF2nONBField gf2n) {
        int mLength = gf2n.getONBLength();
        long[] polynomial = new long[mLength];
        for (int i2 = 0; i2 < mLength - 1; ++i2) {
            polynomial[i2] = -1L;
        }
        polynomial[mLength - 1] = mMaxmask[gf2n.getONBBit() - 1];
        return new GF2nONBElement(gf2n, polynomial);
    }

    @Override
    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    @Override
    void assignOne() {
        for (int i2 = 0; i2 < this.mLength - 1; ++i2) {
            this.mPol[i2] = -1L;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    private void assign(BigInteger val) {
        this.assign(val.toByteArray());
    }

    private void assign(long[] val) {
        System.arraycopy(val, 0, this.mPol, 0, this.mLength);
    }

    private void assign(byte[] val) {
        this.mPol = new long[this.mLength];
        for (int j2 = 0; j2 < val.length; ++j2) {
            int n2 = j2 >>> 3;
            this.mPol[n2] = this.mPol[n2] | ((long)val[val.length - 1 - j2] & 0xFFL) << ((j2 & 7) << 3);
        }
    }

    @Override
    public boolean isZero() {
        boolean result = true;
        for (int i2 = 0; i2 < this.mLength && result; ++i2) {
            result = result && this.mPol[i2] == 0L;
        }
        return result;
    }

    @Override
    public boolean isOne() {
        boolean result = true;
        for (int i2 = 0; i2 < this.mLength - 1 && result; ++i2) {
            result = result && this.mPol[i2] == -1L;
        }
        if (result) {
            result = result && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement otherElem = (GF2nONBElement)other;
        for (int i2 = 0; i2 < this.mLength; ++i2) {
            if (this.mPol[i2] == otherElem.mPol[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.mPol.hashCode();
    }

    @Override
    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    @Override
    boolean testBit(int index) {
        if (index < 0 || index > this.mDegree) {
            return false;
        }
        long test = this.mPol[index >>> 6] & mBitmask[index & 0x3F];
        return test != 0L;
    }

    private long[] getElement() {
        long[] result = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, result, 0, this.mPol.length);
        return result;
    }

    private long[] getElementReverseOrder() {
        long[] result = new long[this.mPol.length];
        for (int i2 = 0; i2 < this.mDegree; ++i2) {
            if (!this.testBit(this.mDegree - i2 - 1)) continue;
            int n2 = i2 >>> 6;
            result[n2] = result[n2] | mBitmask[i2 & 0x3F];
        }
        return result;
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    @Override
    public GFElement add(GFElement addend) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.addToThis(addend);
        return result;
    }

    @Override
    public void addToThis(GFElement addend) throws RuntimeException {
        if (!(addend instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)addend).mField)) {
            throw new RuntimeException();
        }
        for (int i2 = 0; i2 < this.mLength; ++i2) {
            int n2 = i2;
            this.mPol[n2] = this.mPol[n2] ^ ((GF2nONBElement)addend).mPol[i2];
        }
    }

    @Override
    public GF2nElement increase() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.increaseThis();
        return result;
    }

    @Override
    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    @Override
    public GFElement multiply(GFElement factor) throws RuntimeException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.multiplyThisBy(factor);
        return result;
    }

    @Override
    public void multiplyThisBy(GFElement factor) throws RuntimeException {
        if (!(factor instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)factor).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(factor)) {
            this.squareThis();
            return;
        }
        long[] a2 = this.mPol;
        long[] b2 = ((GF2nONBElement)factor).mPol;
        long[] c2 = new long[this.mLength];
        int[][] m2 = ((GF2nONBField)this.mField).mMult;
        int degf = this.mLength - 1;
        int degb = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        long TWOTODEGB = mBitmask[degb];
        for (int k2 = 0; k2 < this.mDegree; ++k2) {
            boolean old;
            int bita;
            int fielda;
            int i2;
            boolean s2 = false;
            for (i2 = 0; i2 < this.mDegree; ++i2) {
                fielda = mIBY64[i2];
                bita = i2 & 0x3F;
                int fieldb = mIBY64[m2[i2][0]];
                int bitb = m2[i2][0] & 0x3F;
                if ((a2[fielda] & mBitmask[bita]) == 0L) continue;
                if ((b2[fieldb] & mBitmask[bitb]) != 0L) {
                    s2 ^= true;
                }
                if (m2[i2][1] == -1 || (b2[fieldb = mIBY64[m2[i2][1]]] & mBitmask[bitb = m2[i2][1] & 0x3F]) == 0L) continue;
                s2 ^= true;
            }
            fielda = mIBY64[k2];
            bita = k2 & 0x3F;
            if (s2) {
                int n2 = fielda;
                c2[n2] = c2[n2] ^ mBitmask[bita];
            }
            if (this.mLength > 1) {
                boolean now;
                old = (a2[degf] & 1L) == 1L;
                for (i2 = degf - 1; i2 >= 0; --i2) {
                    now = (a2[i2] & 1L) != 0L;
                    a2[i2] = a2[i2] >>> 1;
                    if (old) {
                        int n3 = i2;
                        a2[n3] = a2[n3] ^ TWOTOMAXLONGM1;
                    }
                    old = now;
                }
                a2[degf] = a2[degf] >>> 1;
                if (old) {
                    int n4 = degf;
                    a2[n4] = a2[n4] ^ TWOTODEGB;
                }
                old = (b2[degf] & 1L) == 1L;
                for (i2 = degf - 1; i2 >= 0; --i2) {
                    now = (b2[i2] & 1L) != 0L;
                    b2[i2] = b2[i2] >>> 1;
                    if (old) {
                        int n5 = i2;
                        b2[n5] = b2[n5] ^ TWOTOMAXLONGM1;
                    }
                    old = now;
                }
                b2[degf] = b2[degf] >>> 1;
                if (!old) continue;
                int n6 = degf;
                b2[n6] = b2[n6] ^ TWOTODEGB;
                continue;
            }
            old = (a2[0] & 1L) == 1L;
            a2[0] = a2[0] >>> 1;
            if (old) {
                a2[0] = a2[0] ^ TWOTODEGB;
            }
            old = (b2[0] & 1L) == 1L;
            b2[0] = b2[0] >>> 1;
            if (!old) continue;
            b2[0] = b2[0] ^ TWOTODEGB;
        }
        this.assign(c2);
    }

    @Override
    public GF2nElement square() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareThis();
        return result;
    }

    @Override
    public void squareThis() {
        boolean now;
        long[] pol = this.getElement();
        int f2 = this.mLength - 1;
        int b2 = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[f2] & mBitmask[b2]) != 0L;
        for (int i2 = 0; i2 < f2; ++i2) {
            now = (pol[i2] & TWOTOMAXLONGM1) != 0L;
            pol[i2] = pol[i2] << 1;
            if (old) {
                int n2 = i2;
                pol[n2] = pol[n2] ^ 1L;
            }
            old = now;
        }
        now = (pol[f2] & mBitmask[b2]) != 0L;
        pol[f2] = pol[f2] << 1;
        if (old) {
            int n3 = f2;
            pol[n3] = pol[n3] ^ 1L;
        }
        if (now) {
            int n4 = f2;
            pol[n4] = pol[n4] ^ mBitmask[b2 + 1];
        }
        this.assign(pol);
    }

    @Override
    public GFElement invert() throws ArithmeticException {
        GF2nONBElement result = new GF2nONBElement(this);
        result.invertThis();
        return result;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        boolean found = false;
        for (int r2 = 31; !found && r2 >= 0; --r2) {
            if (((long)(this.mDegree - 1) & mBitmask[r2]) == 0L) continue;
            found = true;
        }
        GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement n2 = new GF2nONBElement(this);
        int k2 = 1;
        for (int i2 = ++r2 - 1; i2 >= 0; --i2) {
            GF2nElement m2 = (GF2nElement)((GF2nElement)n2).clone();
            for (int j2 = 1; j2 <= k2; ++j2) {
                m2.squareThis();
            }
            n2.multiplyThisBy(m2);
            k2 <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[i2]) == 0L) continue;
            ((GF2nElement)n2).squareThis();
            n2.multiplyThisBy(this);
            ++k2;
        }
        ((GF2nElement)n2).squareThis();
    }

    @Override
    public GF2nElement squareRoot() {
        GF2nONBElement result = new GF2nONBElement(this);
        result.squareRootThis();
        return result;
    }

    @Override
    public void squareRootThis() {
        long[] pol = this.getElement();
        int f2 = this.mLength - 1;
        int b2 = this.mBit - 1;
        long TWOTOMAXLONGM1 = mBitmask[63];
        boolean old = (pol[0] & 1L) != 0L;
        for (int i2 = f2; i2 >= 0; --i2) {
            boolean now = (pol[i2] & 1L) != 0L;
            pol[i2] = pol[i2] >>> 1;
            if (old) {
                if (i2 == f2) {
                    int n2 = i2;
                    pol[n2] = pol[n2] ^ mBitmask[b2];
                } else {
                    int n3 = i2;
                    pol[n3] = pol[n3] ^ TWOTOMAXLONGM1;
                }
            }
            old = now;
        }
        this.assign(pol);
    }

    @Override
    public int trace() {
        int j2;
        int result = 0;
        int max = this.mLength - 1;
        for (int i2 = 0; i2 < max; ++i2) {
            for (j2 = 0; j2 < 64; ++j2) {
                if ((this.mPol[i2] & mBitmask[j2]) == 0L) continue;
                result ^= 1;
            }
        }
        int b2 = this.mBit;
        for (j2 = 0; j2 < b2; ++j2) {
            if ((this.mPol[max] & mBitmask[j2]) == 0L) continue;
            result ^= 1;
        }
        return result;
    }

    @Override
    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        int j2;
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long TWOTOMAXLONGM1 = mBitmask[63];
        long[] p2 = new long[this.mLength];
        long z2 = 0L;
        for (int i2 = 0; i2 < this.mLength - 1; ++i2) {
            for (j2 = 1; j2 < 64; ++j2) {
                if ((mBitmask[j2] & this.mPol[i2]) != 0L && (z2 & mBitmask[j2 - 1]) != 0L || (this.mPol[i2] & mBitmask[j2]) == 0L && (z2 & mBitmask[j2 - 1]) == 0L) continue;
                z2 ^= mBitmask[j2];
            }
            p2[i2] = z2;
            z2 = (TWOTOMAXLONGM1 & z2) != 0L && (1L & this.mPol[i2 + 1]) == 1L || (TWOTOMAXLONGM1 & z2) == 0L && (1L & this.mPol[i2 + 1]) == 0L ? 0L : 1L;
        }
        int b2 = this.mDegree & 0x3F;
        long LASTLONG = this.mPol[this.mLength - 1];
        for (j2 = 1; j2 < b2; ++j2) {
            if ((mBitmask[j2] & LASTLONG) != 0L && (mBitmask[j2 - 1] & z2) != 0L || (mBitmask[j2] & LASTLONG) == 0L && (mBitmask[j2 - 1] & z2) == 0L) continue;
            z2 ^= mBitmask[j2];
        }
        p2[this.mLength - 1] = z2;
        return new GF2nONBElement((GF2nONBField)this.mField, p2);
    }

    @Override
    public String toString() {
        return this.toString(16);
    }

    @Override
    public String toString(int radix) {
        String s2;
        block5: {
            long[] a2;
            block4: {
                s2 = "";
                a2 = this.getElement();
                int b2 = this.mBit;
                if (radix != 2) break block4;
                for (int j2 = b2 - 1; j2 >= 0; --j2) {
                    s2 = (a2[a2.length - 1] & 1L << j2) == 0L ? s2 + "0" : s2 + "1";
                }
                for (int i2 = a2.length - 2; i2 >= 0; --i2) {
                    for (int j3 = 63; j3 >= 0; --j3) {
                        s2 = (a2[i2] & mBitmask[j3]) == 0L ? s2 + "0" : s2 + "1";
                    }
                }
                break block5;
            }
            if (radix != 16) break block5;
            char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            for (int i3 = a2.length - 1; i3 >= 0; --i3) {
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 60) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 56) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 52) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 48) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 44) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 40) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 36) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 32) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 28) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 24) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 20) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 16) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 12) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 8) & 0xF];
                s2 = s2 + HEX_CHARS[(int)(a2[i3] >>> 4) & 0xF];
                s2 = s2 + HEX_CHARS[(int)a2[i3] & 0xF];
                s2 = s2 + " ";
            }
        }
        return s2;
    }

    @Override
    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        int k2 = (this.mDegree - 1 >> 3) + 1;
        byte[] result = new byte[k2];
        for (int i2 = 0; i2 < k2; ++i2) {
            result[k2 - i2 - 1] = (byte)((this.mPol[i2 >>> 3] & 255L << ((i2 & 7) << 3)) >>> ((i2 & 7) << 3));
        }
        return result;
    }
}

