/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece;

import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;

public final class McElieceCCA2Primitives {
    private McElieceCCA2Primitives() {
    }

    public static GF2Vector encryptionPrimitive(McElieceCCA2PublicKeyParameters pubKey, GF2Vector m2, GF2Vector z2) {
        GF2Matrix matrixG = pubKey.getMatrixG();
        Vector mG = matrixG.leftMultiplyLeftCompactForm(m2);
        return (GF2Vector)mG.add(z2);
    }

    public static GF2Vector[] decryptionPrimitive(McElieceCCA2PrivateKeyParameters privKey, GF2Vector c2) {
        int k2 = privKey.getK();
        Permutation p2 = privKey.getP();
        GF2mField field = privKey.getField();
        PolynomialGF2mSmallM gp = privKey.getGoppaPoly();
        GF2Matrix h2 = privKey.getH();
        PolynomialGF2mSmallM[] q2 = privKey.getQInv();
        Permutation pInv = p2.computeInverse();
        GF2Vector cPInv = (GF2Vector)c2.multiply(pInv);
        GF2Vector syndVec = (GF2Vector)h2.rightMultiply(cPInv);
        GF2Vector errors = GoppaCode.syndromeDecode(syndVec, field, gp, q2);
        GF2Vector mG = (GF2Vector)cPInv.add(errors);
        mG = (GF2Vector)mG.multiply(p2);
        errors = (GF2Vector)errors.multiply(p2);
        GF2Vector m2 = mG.extractRightVector(k2);
        return new GF2Vector[]{m2, errors};
    }
}

