/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[0]);
    protected com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[] certs;

    protected static Certificate parse(InputStream is) throws IOException {
        int left = TlsUtils.readUint24(is);
        if (left == 0) {
            return EMPTY_CHAIN;
        }
        Vector<com.timevale.tgtext.bouncycastle.asn1.x509.Certificate> tmp = new Vector<com.timevale.tgtext.bouncycastle.asn1.x509.Certificate>();
        while (left > 0) {
            int size = TlsUtils.readUint24(is);
            left -= size + 3;
            byte[] buf = new byte[size];
            TlsUtils.readFully(buf, is);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ASN1InputStream ais = new ASN1InputStream(bis);
            ASN1Primitive o2 = ais.readObject();
            tmp.addElement(com.timevale.tgtext.bouncycastle.asn1.x509.Certificate.getInstance(o2));
            if (bis.available() <= 0) continue;
            throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
        }
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[] certs = new com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[tmp.size()];
        for (int i2 = 0; i2 < tmp.size(); ++i2) {
            certs[i2] = (com.timevale.tgtext.bouncycastle.asn1.x509.Certificate)tmp.elementAt(i2);
        }
        return new Certificate(certs);
    }

    protected void encode(OutputStream os) throws IOException {
        byte[] encCert;
        int i2;
        Vector<byte[]> encCerts = new Vector<byte[]>();
        int totalSize = 0;
        for (i2 = 0; i2 < this.certs.length; ++i2) {
            encCert = this.certs[i2].getEncoded("DER");
            encCerts.addElement(encCert);
            totalSize += encCert.length + 3;
        }
        TlsUtils.writeUint24(totalSize, os);
        for (i2 = 0; i2 < encCerts.size(); ++i2) {
            encCert = (byte[])encCerts.elementAt(i2);
            TlsUtils.writeOpaque24(encCert, os);
        }
    }

    public Certificate(com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[] certs) {
        if (certs == null) {
            throw new IllegalArgumentException("'certs' cannot be null");
        }
        this.certs = certs;
    }

    public com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[] getCerts() {
        com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[] result = new com.timevale.tgtext.bouncycastle.asn1.x509.Certificate[this.certs.length];
        System.arraycopy(this.certs, 0, result, 0, this.certs.length);
        return result;
    }

    public boolean isEmpty() {
        return this.certs.length == 0;
    }
}

