/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.text;

import com.timevale.tgtext.text.pdf.draw.b;

public class TabStop {
    protected float a;
    protected Alignment b = Alignment.LEFT;
    protected b c;
    protected char d = (char)46;

    public static TabStop a(float currentPosition, float tabInterval) {
        currentPosition = (float)Math.round(currentPosition * 1000.0f) / 1000.0f;
        tabInterval = (float)Math.round(tabInterval * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(currentPosition + tabInterval - currentPosition % tabInterval);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, b leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, b leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, b leader, Alignment alignment, char anchorChar) {
        this.a = position;
        this.c = leader;
        this.b = alignment;
        this.d = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.a(), tabStop.c(), tabStop.b(), tabStop.d());
    }

    public float a() {
        return this.a;
    }

    public void a(float position) {
        this.a = position;
    }

    public Alignment b() {
        return this.b;
    }

    public void a(Alignment alignment) {
        this.b = alignment;
    }

    public b c() {
        return this.c;
    }

    public void a(b leader) {
        this.c = leader;
    }

    public char d() {
        return this.d;
    }

    public void a(char anchorChar) {
        this.d = anchorChar;
    }

    public float a(float tabPosition, float currentPosition, float anchorPosition) {
        float newPosition = this.a;
        float textWidth = currentPosition - tabPosition;
        switch (this.b) {
            case RIGHT: {
                if (tabPosition + textWidth < this.a) {
                    newPosition = this.a - textWidth;
                    break;
                }
                newPosition = tabPosition;
                break;
            }
            case CENTER: {
                if (tabPosition + textWidth / 2.0f < this.a) {
                    newPosition = this.a - textWidth / 2.0f;
                    break;
                }
                newPosition = tabPosition;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(anchorPosition)) {
                    if (anchorPosition < this.a) {
                        newPosition = this.a - (anchorPosition - tabPosition);
                        break;
                    }
                    newPosition = tabPosition;
                    break;
                }
                newPosition = tabPosition + textWidth < this.a ? this.a - textWidth : tabPosition;
            }
        }
        return newPosition;
    }

    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

