/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.cert.crmf.PKMACValuesCalculator;
import com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JcePKMACValuesCalculator
implements PKMACValuesCalculator {
    private MessageDigest digest;
    private Mac mac;
    private a helper = new a(new DefaultJcaJceHelper());

    public JcePKMACValuesCalculator setProvider(Provider provider) {
        this.helper = new a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePKMACValuesCalculator setProvider(String providerName) {
        this.helper = new a(new NamedJcaJceHelper(providerName));
        return this;
    }

    @Override
    public void setup(AlgorithmIdentifier digAlg, AlgorithmIdentifier macAlg) throws CRMFException {
        this.digest = this.helper.e(digAlg.getAlgorithm());
        this.mac = this.helper.f(macAlg.getAlgorithm());
    }

    @Override
    public byte[] calculateDigest(byte[] data) {
        return this.digest.digest(data);
    }

    @Override
    public byte[] calculateMac(byte[] pwd, byte[] data) throws CRMFException {
        try {
            this.mac.init(new SecretKeySpec(pwd, this.mac.getAlgorithm()));
            return this.mac.doFinal(data);
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("failure in setup: " + e2.getMessage(), e2);
        }
    }
}

