/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public final class BigEndianConversions {
    private BigEndianConversions() {
    }

    public static byte[] I2OSP(int x2) {
        byte[] byArray = new byte[4];
        byte[] result = byArray;
        byArray[0] = x2 >> 24;
        result[1] = (byte)(x2 >>> 16);
        result[2] = (byte)(x2 >>> 8);
        result[3] = (byte)x2;
        return result;
    }

    public static byte[] I2OSP(int x2, int oLen) throws ArithmeticException {
        if (x2 < 0) {
            return null;
        }
        int octL = IntegerFunctions.ceilLog256(x2);
        if (octL > oLen) {
            throw new ArithmeticException("Cannot encode given integer into specified number of octets.");
        }
        byte[] result = new byte[oLen];
        for (int i2 = oLen - 1; i2 >= oLen - octL; --i2) {
            result[i2] = (byte)(x2 >>> 8 * (oLen - 1 - i2));
        }
        return result;
    }

    public static void I2OSP(int input, byte[] output, int outOff) {
        output[outOff++] = input >> 24;
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static byte[] I2OSP(long input) {
        byte[] byArray = new byte[8];
        byte[] output = byArray;
        byArray[0] = (byte)(input >>> 56);
        output[1] = (byte)(input >>> 48);
        output[2] = (byte)(input >>> 40);
        output[3] = (byte)(input >>> 32);
        output[4] = (byte)(input >>> 24);
        output[5] = (byte)(input >>> 16);
        output[6] = (byte)(input >>> 8);
        output[7] = (byte)input;
        return output;
    }

    public static void I2OSP(long input, byte[] output, int outOff) {
        output[outOff++] = (byte)(input >>> 56);
        output[outOff++] = (byte)(input >>> 48);
        output[outOff++] = (byte)(input >>> 40);
        output[outOff++] = (byte)(input >>> 32);
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static void I2OSP(int input, byte[] output, int outOff, int length) {
        for (int i2 = length - 1; i2 >= 0; --i2) {
            output[outOff + i2] = (byte)(input >>> 8 * (length - 1 - i2));
        }
    }

    public static int OS2IP(byte[] input) {
        if (input.length > 4) {
            throw new ArithmeticException("invalid input length");
        }
        if (input.length == 0) {
            return 0;
        }
        int result = 0;
        for (int j2 = 0; j2 < input.length; ++j2) {
            result |= (input[j2] & 0xFF) << 8 * (input.length - 1 - j2);
        }
        return result;
    }

    public static int OS2IP(byte[] input, int inOff) {
        int result = (input[inOff++] & 0xFF) << 24;
        result |= (input[inOff++] & 0xFF) << 16;
        result |= (input[inOff++] & 0xFF) << 8;
        return result |= input[inOff] & 0xFF;
    }

    public static int OS2IP(byte[] input, int inOff, int inLen) {
        if (input.length == 0 || input.length < inOff + inLen - 1) {
            return 0;
        }
        int result = 0;
        for (int j2 = 0; j2 < inLen; ++j2) {
            result |= (input[inOff + j2] & 0xFF) << 8 * (inLen - j2 - 1);
        }
        return result;
    }

    public static long OS2LIP(byte[] input, int inOff) {
        long result = ((long)input[inOff++] & 0xFFL) << 56;
        result |= ((long)input[inOff++] & 0xFFL) << 48;
        result |= ((long)input[inOff++] & 0xFFL) << 40;
        result |= ((long)input[inOff++] & 0xFFL) << 32;
        result |= ((long)input[inOff++] & 0xFFL) << 24;
        result |= (long)((input[inOff++] & 0xFF) << 16);
        result |= (long)((input[inOff++] & 0xFF) << 8);
        return result |= (long)(input[inOff] & 0xFF);
    }

    public static byte[] toByteArray(int[] input) {
        byte[] result = new byte[input.length << 2];
        for (int i2 = 0; i2 < input.length; ++i2) {
            BigEndianConversions.I2OSP(input[i2], result, i2 << 2);
        }
        return result;
    }

    public static byte[] toByteArray(int[] input, int length) {
        int intLen = input.length;
        byte[] result = new byte[length];
        int index = 0;
        int i2 = 0;
        while (i2 <= intLen - 2) {
            BigEndianConversions.I2OSP(input[i2], result, index);
            ++i2;
            index += 4;
        }
        BigEndianConversions.I2OSP(input[intLen - 1], result, index, length - index);
        return result;
    }

    public static int[] toIntArray(byte[] input) {
        int intLen = (input.length + 3) / 4;
        int lastLen = input.length & 3;
        int[] result = new int[intLen];
        int index = 0;
        int i2 = 0;
        while (i2 <= intLen - 2) {
            result[i2] = BigEndianConversions.OS2IP(input, index);
            ++i2;
            index += 4;
        }
        result[intLen - 1] = lastLen != 0 ? BigEndianConversions.OS2IP(input, index, lastLen) : BigEndianConversions.OS2IP(input, index);
        return result;
    }
}

