/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCRMFEncryptorBuilder {
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a helper = new com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a(new DefaultJcaJceHelper());
    private SecureRandom random;

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, -1);
    }

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public JceCRMFEncryptorBuilder setProvider(Provider provider) {
        this.helper = new com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceCRMFEncryptorBuilder setProvider(String providerName) {
        this.helper = new com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceCRMFEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CRMFException {
        return new a(this.encryptionOID, this.keySize, this.random);
    }

    private class a
    implements OutputEncryptor {
        private SecretKey b;
        private AlgorithmIdentifier c;
        private Cipher d;

        a(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CRMFException {
            KeyGenerator keyGen = JceCRMFEncryptorBuilder.this.helper.b(encryptionOID);
            if (random == null) {
                random = new SecureRandom();
            }
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.d = JceCRMFEncryptorBuilder.this.helper.a(encryptionOID);
            this.b = keyGen.generateKey();
            AlgorithmParameters params = JceCRMFEncryptorBuilder.this.helper.a(encryptionOID, this.b, random);
            try {
                this.d.init(1, (Key)this.b, params, random);
            }
            catch (GeneralSecurityException e2) {
                throw new CRMFException("unable to initialize cipher: " + e2.getMessage(), e2);
            }
            if (params == null) {
                params = this.d.getParameters();
            }
            this.c = JceCRMFEncryptorBuilder.this.helper.a(encryptionOID, params);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStream(dOut, this.d);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.c, this.b);
        }
    }
}

