/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.mceliece;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.pqc.asn1.McEliecePublicKey;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.spec.McEliecePublicKeySpec;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.io.IOException;
import java.security.PublicKey;

public class BCMcEliecePublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private String oid;
    private int n;
    private int t;
    private GF2Matrix g;
    private McElieceParameters McElieceParams;

    public BCMcEliecePublicKey(String oid, int n2, int t2, GF2Matrix g2) {
        this.oid = oid;
        this.n = n2;
        this.t = t2;
        this.g = g2;
    }

    public BCMcEliecePublicKey(McEliecePublicKeySpec keySpec) {
        this(keySpec.getOIDString(), keySpec.getN(), keySpec.getT(), keySpec.getG());
    }

    public BCMcEliecePublicKey(McEliecePublicKeyParameters params) {
        this(params.getOIDString(), params.getN(), params.getT(), params.getG());
        this.McElieceParams = params.getParameters();
    }

    @Override
    public String getAlgorithm() {
        return "McEliece";
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.g.getNumRows();
    }

    public int getT() {
        return this.t;
    }

    public GF2Matrix getG() {
        return this.g;
    }

    public String toString() {
        String result = "McEliecePublicKey:\n";
        result = result + " length of the code         : " + this.n + "\n";
        result = result + " error correction capability: " + this.t + "\n";
        result = result + " generator matrix           : " + this.g.toString();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BCMcEliecePublicKey)) {
            return false;
        }
        BCMcEliecePublicKey otherKey = (BCMcEliecePublicKey)other;
        return this.n == otherKey.n && this.t == otherKey.t && this.g.equals(otherKey.g);
    }

    public int hashCode() {
        return this.n + this.t + this.g.hashCode();
    }

    public String getOIDString() {
        return this.oid;
    }

    protected ASN1ObjectIdentifier getOID() {
        return new ASN1ObjectIdentifier("1.3.6.1.4.1.8301.3.1.3.4.1");
    }

    protected ASN1Primitive getAlgParams() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        McEliecePublicKey key = new McEliecePublicKey(new ASN1ObjectIdentifier(this.oid), this.n, this.t, this.g);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.getOID(), (ASN1Encodable)DERNull.INSTANCE);
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, key);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return null;
    }

    public McElieceParameters getMcElieceParameters() {
        return this.McElieceParams;
    }
}

