/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERInteger;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERUTF8String;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFreeText;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TSPValidationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TimeStampResponseGenerator {
    int status;
    ASN1EncodableVector statusStrings;
    int failInfo;
    private TimeStampTokenGenerator tokenGenerator;
    private Set acceptedAlgorithms;
    private Set acceptedPolicies;
    private Set acceptedExtensions;

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms) {
        this(tokenGenerator, acceptedAlgorithms, null, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies) {
        this(tokenGenerator, acceptedAlgorithms, acceptedPolicies, null);
    }

    public TimeStampResponseGenerator(TimeStampTokenGenerator tokenGenerator, Set acceptedAlgorithms, Set acceptedPolicies, Set acceptedExtensions) {
        this.tokenGenerator = tokenGenerator;
        this.acceptedAlgorithms = this.convert(acceptedAlgorithms);
        this.acceptedPolicies = this.convert(acceptedPolicies);
        this.acceptedExtensions = this.convert(acceptedExtensions);
        this.statusStrings = new ASN1EncodableVector();
    }

    private void addStatusString(String statusString) {
        this.statusStrings.add(new DERUTF8String(statusString));
    }

    private void setFailInfoField(int field) {
        this.failInfo |= field;
    }

    private PKIStatusInfo getPKIStatusInfo() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(new DERInteger(this.status));
        if (this.statusStrings.size() > 0) {
            v2.add(PKIFreeText.getInstance(new DERSequence(this.statusStrings)));
        }
        if (this.failInfo != 0) {
            a failInfoBitString = new a(this.failInfo);
            v2.add(failInfoBitString);
        }
        return PKIStatusInfo.getInstance(new DERSequence(v2));
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        TimeStampResp resp;
        try {
            ContentInfo tstTokenContentInfo;
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions, provider);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime, provider).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream(bIn);
                tstTokenContentInfo = ContentInfo.getInstance(aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e2) {
            this.status = 2;
            this.setFailInfoField(e2.getFailureCode());
            this.addStatusString(e2.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        TimeStampResp resp;
        try {
            ContentInfo tstTokenContentInfo;
            if (genTime == null) {
                throw new TSPValidationException("The time source is not available.", 512);
            }
            request.validate(this.acceptedAlgorithms, this.acceptedPolicies, this.acceptedExtensions);
            this.status = 0;
            this.addStatusString("Operation Okay");
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            try {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.tokenGenerator.generate(request, serialNumber, genTime).toCMSSignedData().getEncoded());
                ASN1InputStream aIn = new ASN1InputStream(bIn);
                tstTokenContentInfo = ContentInfo.getInstance(aIn.readObject());
            }
            catch (IOException ioEx) {
                throw new TSPException("Timestamp token received cannot be converted to ContentInfo", ioEx);
            }
            resp = new TimeStampResp(pkiStatusInfo, tstTokenContentInfo);
        }
        catch (TSPValidationException e2) {
            this.status = 2;
            this.setFailInfoField(e2.getFailureCode());
            this.addStatusString(e2.getMessage());
            PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
            resp = new TimeStampResp(pkiStatusInfo, null);
        }
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    public TimeStampResponse generateFailResponse(int status, int failInfoField, String statusString) throws TSPException {
        this.status = status;
        this.setFailInfoField(failInfoField);
        if (statusString != null) {
            this.addStatusString(statusString);
        }
        PKIStatusInfo pkiStatusInfo = this.getPKIStatusInfo();
        TimeStampResp resp = new TimeStampResp(pkiStatusInfo, null);
        try {
            return new TimeStampResponse(resp);
        }
        catch (IOException iOException) {
            throw new TSPException("created badly formatted response!");
        }
    }

    private Set convert(Set orig) {
        if (orig == null) {
            return orig;
        }
        HashSet<ASN1ObjectIdentifier> con = new HashSet<ASN1ObjectIdentifier>(orig.size());
        for (Object o2 : orig) {
            if (o2 instanceof String) {
                con.add(new ASN1ObjectIdentifier((String)o2));
                continue;
            }
            con.add((ASN1ObjectIdentifier)o2);
        }
        return con;
    }

    class a
    extends DERBitString {
        a(int failInfoValue) {
            super(com.timevale.tgtext.bouncycastle.tsp.TimeStampResponseGenerator$a.getBytes(failInfoValue), com.timevale.tgtext.bouncycastle.tsp.TimeStampResponseGenerator$a.getPadBits(failInfoValue));
        }
    }
}

