/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cms;

import com.timevale.tgtext.bouncycastle.asn1.cms.KEKIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedStream;
import com.timevale.tgtext.bouncycastle.cms.KEKRecipient;
import com.timevale.tgtext.bouncycastle.cms.KEKRecipientId;
import com.timevale.tgtext.bouncycastle.cms.Recipient;
import com.timevale.tgtext.bouncycastle.cms.RecipientInformation;
import com.timevale.tgtext.bouncycastle.cms.RecipientOperator;
import com.timevale.tgtext.bouncycastle.cms.a;
import com.timevale.tgtext.bouncycastle.cms.d;
import com.timevale.tgtext.bouncycastle.cms.g;
import com.timevale.tgtext.bouncycastle.cms.i;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKEKAuthenticatedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JceKEKRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, g secureReadable, a additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, i.a(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKEKRecipient recipient = this.secureReadable instanceof d.c ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e2) {
            throw new CMSException("encoding error: " + e2.getMessage(), e2);
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

