/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.eac.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.eac.operator.EACSigner;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.b;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.d;
import com.timevale.tgtext.bouncycastle.eac.operator.jcajce.e;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.OperatorStreamException;
import com.timevale.tgtext.bouncycastle.operator.RuntimeOperatorException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Hashtable;

public class JcaEACSignerBuilder {
    private static final Hashtable sigNames = new Hashtable<String, ASN1ObjectIdentifier>();
    private b helper = new com.timevale.tgtext.bouncycastle.eac.operator.jcajce.a();

    public JcaEACSignerBuilder setProvider(String providerName) {
        this.helper = new d(providerName);
        return this;
    }

    public JcaEACSignerBuilder setProvider(Provider provider) {
        this.helper = new e(provider);
        return this;
    }

    public EACSigner build(String algorithm, PrivateKey privKey) throws OperatorCreationException {
        return this.build((ASN1ObjectIdentifier)sigNames.get(algorithm), privKey);
    }

    public EACSigner build(final ASN1ObjectIdentifier usageOid, PrivateKey privKey) throws OperatorCreationException {
        Signature sig;
        try {
            sig = this.helper.a(usageOid);
            sig.initSign(privKey);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new OperatorCreationException("unable to find algorithm: " + e2.getMessage(), e2);
        }
        catch (NoSuchProviderException e3) {
            throw new OperatorCreationException("unable to find provider: " + e3.getMessage(), e3);
        }
        catch (InvalidKeyException e4) {
            throw new OperatorCreationException("invalid key: " + e4.getMessage(), e4);
        }
        final a sigStream = new a(sig);
        return new EACSigner(){

            @Override
            public ASN1ObjectIdentifier getUsageIdentifier() {
                return usageOid;
            }

            @Override
            public OutputStream getOutputStream() {
                return sigStream;
            }

            @Override
            public byte[] getSignature() {
                try {
                    byte[] signature = sigStream.a();
                    if (usageOid.on(EACObjectIdentifiers.id_TA_ECDSA)) {
                        return JcaEACSignerBuilder.reencode(signature);
                    }
                    return signature;
                }
                catch (SignatureException e2) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e2.getMessage(), e2);
                }
            }
        };
    }

    public static int max(int el1, int el2) {
        if (el1 > el2) {
            return el1;
        }
        return el2;
    }

    private static byte[] reencode(byte[] rawSign) {
        ASN1Sequence sData = ASN1Sequence.getInstance(rawSign);
        BigInteger r2 = ASN1Integer.getInstance(sData.getObjectAt(0)).getValue();
        BigInteger s2 = ASN1Integer.getInstance(sData.getObjectAt(1)).getValue();
        byte[] rB = r2.toByteArray();
        byte[] sB = s2.toByteArray();
        int rLen = JcaEACSignerBuilder.unsignedIntLength(rB);
        int sLen = JcaEACSignerBuilder.unsignedIntLength(sB);
        int len = JcaEACSignerBuilder.max(rLen, sLen);
        byte[] ret = new byte[len << 1];
        Arrays.fill(ret, (byte)0);
        JcaEACSignerBuilder.copyUnsignedInt(rB, ret, len - rLen);
        JcaEACSignerBuilder.copyUnsignedInt(sB, ret, 2 * len - sLen);
        return ret;
    }

    private static int unsignedIntLength(byte[] i2) {
        int len = i2.length;
        if (i2[0] == 0) {
            --len;
        }
        return len;
    }

    private static void copyUnsignedInt(byte[] src, byte[] dst, int offset) {
        int len = src.length;
        int readoffset = 0;
        if (src[0] == 0) {
            --len;
            readoffset = 1;
        }
        System.arraycopy(src, readoffset, dst, offset, len);
    }

    static {
        sigNames.put("SHA1withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_1);
        sigNames.put("SHA256withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_256);
        sigNames.put("SHA1withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_1);
        sigNames.put("SHA256withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_256);
        sigNames.put("SHA512withRSA", EACObjectIdentifiers.id_TA_RSA_v1_5_SHA_512);
        sigNames.put("SHA512withRSAandMGF1", EACObjectIdentifiers.id_TA_RSA_PSS_SHA_512);
        sigNames.put("SHA1withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_1);
        sigNames.put("SHA224withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_224);
        sigNames.put("SHA256withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_256);
        sigNames.put("SHA384withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_384);
        sigNames.put("SHA512withECDSA", EACObjectIdentifiers.id_TA_ECDSA_SHA_512);
    }

    private class a
    extends OutputStream {
        private Signature b;

        a(Signature sig) {
            this.b = sig;
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                this.b.update(bytes, off, len);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                this.b.update(bytes);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        @Override
        public void write(int b2) throws IOException {
            try {
                this.b.update((byte)b2);
                return;
            }
            catch (SignatureException e2) {
                throw new OperatorStreamException("exception in content signer: " + e2.getMessage(), e2);
            }
        }

        byte[] a() throws SignatureException {
            return this.b.sign();
        }
    }
}

