/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x500.style;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1String;
import com.timevale.tgtext.bouncycastle.asn1.DERUniversalString;
import com.timevale.tgtext.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.timevale.tgtext.bouncycastle.asn1.x500.RDN;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500NameBuilder;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500NameStyle;
import com.timevale.tgtext.bouncycastle.asn1.x500.style.a;
import com.timevale.tgtext.bouncycastle.util.Strings;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    public static RDN[] rDNsFromString(String name, X500NameStyle x500Style) {
        a nTok = new a(name);
        X500NameBuilder builder = new X500NameBuilder(x500Style);
        while (nTok.a()) {
            String token = nTok.b();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String attr = token.substring(0, index);
            String value = token.substring(index + 1);
            ASN1ObjectIdentifier oid = x500Style.attrNameToOID(attr);
            if (value.indexOf(43) > 0) {
                a vTok = new a(value, '+');
                String v2 = vTok.b();
                Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
                Vector<String> values = new Vector<String>();
                oids.addElement(oid);
                values.addElement(v2);
                while (vTok.a()) {
                    String sv = vTok.b();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    oids.addElement(x500Style.attrNameToOID(nm));
                    values.addElement(vl);
                }
                builder.addMultiValuedRDN(IETFUtils.toOIDArray(oids), IETFUtils.toValueArray(values));
                continue;
            }
            builder.addRDN(oid, value);
        }
        return builder.build().getRDNs();
    }

    private static String[] toValueArray(Vector values) {
        String[] tmp = new String[values.size()];
        for (int i2 = 0; i2 != tmp.length; ++i2) {
            tmp[i2] = (String)values.elementAt(i2);
        }
        return tmp;
    }

    private static ASN1ObjectIdentifier[] toOIDArray(Vector oids) {
        ASN1ObjectIdentifier[] tmp = new ASN1ObjectIdentifier[oids.size()];
        for (int i2 = 0; i2 != tmp.length; ++i2) {
            tmp[i2] = (ASN1ObjectIdentifier)oids.elementAt(i2);
        }
        return tmp;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String name, Hashtable lookUp) {
        if (Strings.toUpperCase(name).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(name);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)lookUp.get(Strings.toLowerCase(name));
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public static ASN1Encodable valueFromHexString(String str, int off) throws IOException {
        str = Strings.toLowerCase(str);
        byte[] data = new byte[(str.length() - off) / 2];
        for (int index = 0; index != data.length; ++index) {
            char left = str.charAt((index << 1) + off);
            char right = str.charAt((index << 1) + off + 1);
            data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
            if (right < 'a') {
                int n2 = index;
                data[n2] = (byte)(data[n2] | (byte)(right - 48));
                continue;
            }
            int n3 = index;
            data[n3] = (byte)(data[n3] | (byte)(right - 97 + 10));
        }
        return ASN1Primitive.fromByteArray(data);
    }

    public static void appendRDN(StringBuffer buf, RDN rdn, Hashtable oidSymbols) {
        if (rdn.isMultiValued()) {
            AttributeTypeAndValue[] atv = rdn.getTypesAndValues();
            boolean firstAtv = true;
            for (int j2 = 0; j2 != atv.length; ++j2) {
                if (firstAtv) {
                    firstAtv = false;
                } else {
                    buf.append('+');
                }
                IETFUtils.appendTypeAndValue(buf, atv[j2], oidSymbols);
            }
            return;
        }
        IETFUtils.appendTypeAndValue(buf, rdn.getFirst(), oidSymbols);
    }

    public static void appendTypeAndValue(StringBuffer buf, AttributeTypeAndValue typeAndValue, Hashtable oidSymbols) {
        String sym = (String)oidSymbols.get(typeAndValue.getType());
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(typeAndValue.getType().getId());
        }
        buf.append('=');
        buf.append(IETFUtils.valueToString(typeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable value) {
        StringBuffer vBuf = new StringBuffer();
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            String v2 = ((ASN1String)((Object)value)).getString();
            if (v2.length() > 0 && v2.charAt(0) == '#') {
                vBuf.append("\\" + v2);
            } else {
                vBuf.append(v2);
            }
        } else {
            try {
                vBuf.append("#" + IETFUtils.bytesToString(Hex.encode(value.toASN1Primitive().getEncoded("DER"))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int end = vBuf.length();
        int index = 0;
        if (vBuf.length() >= 2 && vBuf.charAt(0) == '\\' && vBuf.charAt(1) == '#') {
            index += 2;
        }
        while (index != end) {
            if (vBuf.charAt(index) == ',' || vBuf.charAt(index) == '\"' || vBuf.charAt(index) == '\\' || vBuf.charAt(index) == '+' || vBuf.charAt(index) == '=' || vBuf.charAt(index) == '<' || vBuf.charAt(index) == '>' || vBuf.charAt(index) == ';') {
                vBuf.insert(index, "\\");
                ++index;
                ++end;
            }
            ++index;
        }
        return vBuf.toString();
    }

    private static String bytesToString(byte[] data) {
        char[] cs2 = new char[data.length];
        for (int i2 = 0; i2 != cs2.length; ++i2) {
            cs2[i2] = (char)(data[i2] & 0xFF);
        }
        return new String(cs2);
    }

    public static String canonicalize(String s2) {
        ASN1Primitive obj;
        String value = Strings.toLowerCase(s2.trim());
        if (value.length() > 0 && value.charAt(0) == '#' && (obj = IETFUtils.decodeObject(value)) instanceof ASN1String) {
            value = Strings.toLowerCase(((ASN1String)((Object)obj)).getString().trim());
        }
        value = IETFUtils.stripInternalSpaces(value);
        return value;
    }

    private static ASN1Primitive decodeObject(String oValue) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(oValue.substring(1)));
        }
        catch (IOException e2) {
            throw new IllegalStateException("unknown encoding in name: " + e2);
        }
    }

    public static String stripInternalSpaces(String str) {
        StringBuffer res = new StringBuffer();
        if (str.length() != 0) {
            char c1 = str.charAt(0);
            res.append(c1);
            for (int k2 = 1; k2 < str.length(); ++k2) {
                char c2 = str.charAt(k2);
                if (c1 != ' ' || c2 != ' ') {
                    res.append(c2);
                }
                c1 = c2;
            }
        }
        return res.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean rDNAreEqual(RDN rdn1, RDN rdn2) {
        if (rdn1.isMultiValued()) {
            AttributeTypeAndValue[] atvs2;
            if (!rdn2.isMultiValued()) return false;
            AttributeTypeAndValue[] atvs1 = rdn1.getTypesAndValues();
            if (atvs1.length != (atvs2 = rdn2.getTypesAndValues()).length) {
                return false;
            }
            for (int i2 = 0; i2 != atvs1.length; ++i2) {
                if (IETFUtils.atvAreEqual(atvs1[i2], atvs2[i2])) continue;
                return false;
            }
            return true;
        } else {
            if (rdn2.isMultiValued()) return false;
            return IETFUtils.atvAreEqual(rdn1.getFirst(), rdn2.getFirst());
        }
    }

    private static boolean atvAreEqual(AttributeTypeAndValue atv1, AttributeTypeAndValue atv2) {
        String v2;
        ASN1ObjectIdentifier o2;
        if (atv1 == atv2) {
            return true;
        }
        if (atv1 == null) {
            return false;
        }
        if (atv2 == null) {
            return false;
        }
        ASN1ObjectIdentifier o1 = atv1.getType();
        if (!o1.equals(o2 = atv2.getType())) {
            return false;
        }
        String v1 = IETFUtils.canonicalize(IETFUtils.valueToString(atv1.getValue()));
        return v1.equals(v2 = IETFUtils.canonicalize(IETFUtils.valueToString(atv2.getValue())));
    }
}

