/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private ElGamalKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;
    private int bitSize;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        Object p2;
        if (param instanceof ParametersWithRandom) {
            p2 = (ParametersWithRandom)param;
            this.key = (ElGamalKeyParameters)((ParametersWithRandom)p2).getParameters();
            this.random = ((ParametersWithRandom)p2).getRandom();
        } else {
            this.key = (ElGamalKeyParameters)param;
            this.random = new SecureRandom();
        }
        this.forEncryption = forEncryption;
        p2 = this.key.getParameters().getP();
        this.bitSize = ((BigInteger)p2).bitLength();
        if (forEncryption) {
            if (!(this.key instanceof ElGamalPublicKeyParameters)) {
                throw new IllegalArgumentException("ElGamalPublicKeyParameters are required for encryption.");
            }
        } else if (!(this.key instanceof ElGamalPrivateKeyParameters)) {
            throw new IllegalArgumentException("ElGamalPrivateKeyParameters are required for decryption.");
        }
    }

    @Override
    public int getInputBlockSize() {
        if (this.forEncryption) {
            return (this.bitSize - 1) / 8;
        }
        return 2 * ((this.bitSize + 7) / 8);
    }

    @Override
    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return 2 * ((this.bitSize + 7) / 8);
        }
        return (this.bitSize - 1) / 8;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        byte[] block;
        int maxLength;
        if (this.key == null) {
            throw new IllegalStateException("ElGamal engine not initialised");
        }
        int n2 = maxLength = this.forEncryption ? (this.bitSize - 1 + 7) / 8 : this.getInputBlockSize();
        if (inLen > maxLength) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        BigInteger p2 = this.key.getParameters().getP();
        if (this.key instanceof ElGamalPrivateKeyParameters) {
            byte[] in1 = new byte[inLen / 2];
            byte[] in2 = new byte[inLen / 2];
            System.arraycopy(in, inOff, in1, 0, in1.length);
            System.arraycopy(in, inOff + in1.length, in2, 0, in2.length);
            BigInteger gamma = new BigInteger(1, in1);
            BigInteger phi = new BigInteger(1, in2);
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)this.key;
            BigInteger m2 = gamma.modPow(p2.subtract(ONE).subtract(priv.getX()), p2).multiply(phi).mod(p2);
            return BigIntegers.asUnsignedByteArray(m2);
        }
        if (inOff != 0 || inLen != in.length) {
            block = new byte[inLen];
            System.arraycopy(in, inOff, block, 0, inLen);
        } else {
            block = in;
        }
        BigInteger input = new BigInteger(1, block);
        if (input.bitLength() >= p2.bitLength()) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)this.key;
        int pBitLength = p2.bitLength();
        BigInteger k2 = new BigInteger(pBitLength, this.random);
        while (k2.equals(ZERO) || k2.compareTo(p2.subtract(TWO)) > 0) {
            k2 = new BigInteger(pBitLength, this.random);
        }
        BigInteger g2 = this.key.getParameters().getG();
        BigInteger gamma = g2.modPow(k2, p2);
        BigInteger phi = input.multiply(pub.getY().modPow(k2, p2)).mod(p2);
        byte[] out1 = gamma.toByteArray();
        byte[] out2 = phi.toByteArray();
        byte[] output = new byte[this.getOutputBlockSize()];
        if (out1.length > output.length / 2) {
            System.arraycopy(out1, 1, output, output.length / 2 - (out1.length - 1), out1.length - 1);
        } else {
            System.arraycopy(out1, 0, output, output.length / 2 - out1.length, out1.length);
        }
        if (out2.length > output.length / 2) {
            System.arraycopy(out2, 1, output, output.length - (out2.length - 1), out2.length - 1);
        } else {
            System.arraycopy(out2, 0, output, output.length - out2.length, out2.length);
        }
        return output;
    }
}

