/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.ess;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuerSerial;

public class ESSCertIDv2
extends ASN1Object {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certHash;
    private IssuerSerial issuerSerial;
    private static final AlgorithmIdentifier DEFAULT_ALG_ID = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);

    public static ESSCertIDv2 getInstance(Object o2) {
        if (o2 instanceof ESSCertIDv2) {
            return (ESSCertIDv2)o2;
        }
        if (o2 != null) {
            return new ESSCertIDv2(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ESSCertIDv2(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int count = 0;
        this.hashAlgorithm = seq.getObjectAt(0) instanceof ASN1OctetString ? DEFAULT_ALG_ID : AlgorithmIdentifier.getInstance(seq.getObjectAt(0).toASN1Primitive());
        int n2 = ++count;
        this.certHash = ASN1OctetString.getInstance(seq.getObjectAt(n2).toASN1Primitive()).getOctets();
        if (seq.size() > ++count) {
            this.issuerSerial = IssuerSerial.getInstance(seq.getObjectAt(count));
        }
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash) {
        this(algId, certHash, null);
    }

    public ESSCertIDv2(AlgorithmIdentifier algId, byte[] certHash, IssuerSerial issuerSerial) {
        this.hashAlgorithm = algId == null ? DEFAULT_ALG_ID : algId;
        this.certHash = certHash;
        this.issuerSerial = issuerSerial;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (!this.hashAlgorithm.equals(DEFAULT_ALG_ID)) {
            v2.add(this.hashAlgorithm);
        }
        v2.add(new DEROctetString(this.certHash).toASN1Primitive());
        if (this.issuerSerial != null) {
            v2.add(this.issuerSerial);
        }
        return new DERSequence(v2);
    }
}

