/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.ua;

import com.timevale.tgtext.bouncycastle.asn1.x9.X9IntegerConverter;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.tgtext.bouncycastle.math.ec.ECFieldElement;
import com.timevale.tgtext.bouncycastle.math.ec.ECPoint;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Random;

public abstract class DSTU4145PointEncoder {
    private static X9IntegerConverter converter = new X9IntegerConverter();

    private static BigInteger trace(ECFieldElement fe2) {
        ECFieldElement t2 = fe2;
        for (int i2 = 0; i2 < fe2.getFieldSize() - 1; ++i2) {
            t2 = t2.square().add(fe2);
        }
        return t2.toBigInteger();
    }

    private static ECFieldElement solveQuadradicEquation(ECFieldElement beta) {
        ECFieldElement z2;
        ECFieldElement gamma;
        ECFieldElement.F2m b2 = (ECFieldElement.F2m)beta;
        ECFieldElement.F2m zeroElement = new ECFieldElement.F2m(b2.getM(), b2.getK1(), b2.getK2(), b2.getK3(), ECConstants.ZERO);
        if (beta.toBigInteger().equals(ECConstants.ZERO)) {
            return zeroElement;
        }
        Random rand = new Random();
        int m2 = b2.getM();
        do {
            ECFieldElement.F2m t2 = new ECFieldElement.F2m(b2.getM(), b2.getK1(), b2.getK2(), b2.getK3(), new BigInteger(m2, rand));
            z2 = zeroElement;
            ECFieldElement w2 = beta;
            for (int i2 = 1; i2 <= m2 - 1; ++i2) {
                ECFieldElement w22 = w2.square();
                z2 = ((ECFieldElement)z2).square().add(w22.multiply(t2));
                w2 = w22.add(beta);
            }
            if (w2.toBigInteger().equals(ECConstants.ZERO)) continue;
            return null;
        } while ((gamma = ((ECFieldElement)z2).square().add(z2)).toBigInteger().equals(ECConstants.ZERO));
        return z2;
    }

    public static byte[] encodePoint(ECPoint Q) {
        int byteCount = converter.getByteLength(Q.getX());
        byte[] bytes = converter.integerToBytes(Q.getX().toBigInteger(), byteCount);
        if (!Q.getX().toBigInteger().equals(ECConstants.ZERO)) {
            ECFieldElement y2 = Q.getY().multiply(Q.getX().invert());
            if (DSTU4145PointEncoder.trace(y2).equals(ECConstants.ONE)) {
                int n2 = bytes.length - 1;
                bytes[n2] = (byte)(bytes[n2] | 1);
            } else {
                int n3 = bytes.length - 1;
                bytes[n3] = (byte)(bytes[n3] & 0xFE);
            }
        }
        return bytes;
    }

    public static ECPoint decodePoint(ECCurve curve, byte[] bytes) {
        ECFieldElement yp;
        BigInteger k2 = BigInteger.valueOf(bytes[bytes.length - 1] & 1);
        if (!DSTU4145PointEncoder.trace(curve.fromBigInteger(new BigInteger(1, bytes))).equals(curve.getA().toBigInteger())) {
            byte[] byArray = Arrays.clone(bytes);
            bytes = byArray;
            int n2 = bytes.length - 1;
            byArray[n2] = (byte)(byArray[n2] ^ 1);
        }
        ECCurve.F2m c2 = (ECCurve.F2m)curve;
        ECFieldElement xp = curve.fromBigInteger(new BigInteger(1, bytes));
        if (xp.toBigInteger().equals(ECConstants.ZERO)) {
            yp = (ECFieldElement.F2m)curve.getB();
            for (int i2 = 0; i2 < c2.getM() - 1; ++i2) {
                yp = ((ECFieldElement)yp).square();
            }
        } else {
            ECFieldElement beta = xp.add(curve.getA()).add(curve.getB().multiply(xp.square().invert()));
            ECFieldElement z2 = DSTU4145PointEncoder.solveQuadradicEquation(beta);
            if (z2 == null) {
                throw new RuntimeException("Invalid point compression");
            }
            if (!DSTU4145PointEncoder.trace(z2).equals(k2)) {
                z2 = z2.add(curve.fromBigInteger(ECConstants.ONE));
            }
            yp = xp.multiply(z2);
        }
        return new ECPoint.F2m(curve, xp, yp);
    }
}

