/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert.crmf.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Null;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.cert.crmf.CRMFException;
import com.timevale.tgtext.bouncycastle.cms.CMSAlgorithm;
import com.timevale.tgtext.bouncycastle.jcajce.JcaJceHelper;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

class a {
    protected static final Map a = new HashMap();
    protected static final Map b = new HashMap();
    protected static final Map c = new HashMap();
    protected static final Map d = new HashMap();
    protected static final Map e = new HashMap();
    private JcaJceHelper f;

    a(JcaJceHelper helper) {
        this.f = helper;
    }

    PublicKey a(SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            AlgorithmIdentifier keyAlg = subjectPublicKeyInfo.getAlgorithm();
            return this.d(keyAlg.getAlgorithm()).generatePublic(xspec);
        }
        catch (Exception e2) {
            throw new CRMFException("invalid key: " + e2.getMessage(), e2);
        }
    }

    Cipher a(ASN1ObjectIdentifier algorithm) throws CRMFException {
        try {
            String cipherName = (String)b.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.f.createCipher(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return this.f.createCipher(algorithm.getId());
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("cannot create cipher: " + e2.getMessage(), e2);
        }
    }

    public KeyGenerator b(ASN1ObjectIdentifier algorithm) throws CRMFException {
        try {
            String cipherName = (String)a.get(algorithm);
            if (cipherName != null) {
                try {
                    return this.f.createKeyGenerator(cipherName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return this.f.createKeyGenerator(algorithm.getId());
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("cannot create key generator: " + e2.getMessage(), e2);
        }
    }

    Cipher a(final Key sKey, final AlgorithmIdentifier encryptionAlgID) throws CRMFException {
        return (Cipher)com.timevale.tgtext.bouncycastle.cert.crmf.jcajce.a.a(new a(){

            @Override
            public Object a() throws CRMFException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
                Cipher cipher = a.this.a(encryptionAlgID.getAlgorithm());
                ASN1Primitive sParams = (ASN1Primitive)encryptionAlgID.getParameters();
                ASN1ObjectIdentifier encAlg = encryptionAlgID.getAlgorithm();
                if (sParams != null && !(sParams instanceof ASN1Null)) {
                    try {
                        AlgorithmParameters params = a.this.c(encryptionAlgID.getAlgorithm());
                        try {
                            params.init(sParams.getEncoded(), "ASN.1");
                        }
                        catch (IOException e2) {
                            throw new CRMFException("error decoding algorithm parameters.", e2);
                        }
                        cipher.init(2, sKey, params);
                    }
                    catch (NoSuchAlgorithmException e3) {
                        if (encAlg.equals(CMSAlgorithm.DES_EDE3_CBC) || encAlg.equals(CMSAlgorithm.IDEA_CBC) || encAlg.equals(CMSAlgorithm.AES128_CBC) || encAlg.equals(CMSAlgorithm.AES192_CBC) || encAlg.equals(CMSAlgorithm.AES256_CBC)) {
                            cipher.init(2, sKey, new IvParameterSpec(ASN1OctetString.getInstance(sParams).getOctets()));
                        }
                        throw e3;
                    }
                } else if (encAlg.equals(CMSAlgorithm.DES_EDE3_CBC) || encAlg.equals(CMSAlgorithm.IDEA_CBC) || encAlg.equals(CMSAlgorithm.CAST5_CBC)) {
                    cipher.init(2, sKey, new IvParameterSpec(new byte[8]));
                } else {
                    cipher.init(2, sKey);
                }
                return cipher;
            }
        });
    }

    AlgorithmParameters c(ASN1ObjectIdentifier algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        String algorithmName = (String)a.get(algorithm);
        if (algorithmName != null) {
            try {
                return this.f.createAlgorithmParameters(algorithmName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return this.f.createAlgorithmParameters(algorithm.getId());
    }

    KeyFactory d(ASN1ObjectIdentifier algorithm) throws CRMFException {
        try {
            String algName = (String)d.get(algorithm);
            if (algName != null) {
                try {
                    return this.f.createKeyFactory(algName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return this.f.createKeyFactory(algorithm.getId());
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("cannot create cipher: " + e2.getMessage(), e2);
        }
    }

    MessageDigest e(ASN1ObjectIdentifier algorithm) throws CRMFException {
        try {
            String digestName = (String)c.get(algorithm);
            if (digestName != null) {
                try {
                    return this.f.createDigest(digestName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return this.f.createDigest(algorithm.getId());
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("cannot create cipher: " + e2.getMessage(), e2);
        }
    }

    Mac f(ASN1ObjectIdentifier algorithm) throws CRMFException {
        try {
            String macName = (String)e.get(algorithm);
            if (macName != null) {
                try {
                    return this.f.createMac(macName);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            return this.f.createMac(algorithm.getId());
        }
        catch (GeneralSecurityException e2) {
            throw new CRMFException("cannot create mac: " + e2.getMessage(), e2);
        }
    }

    AlgorithmParameterGenerator g(ASN1ObjectIdentifier algorithm) throws GeneralSecurityException {
        String algorithmName = (String)a.get(algorithm);
        if (algorithmName != null) {
            try {
                return this.f.createAlgorithmParameterGenerator(algorithmName);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return this.f.createAlgorithmParameterGenerator(algorithm.getId());
    }

    AlgorithmParameters a(ASN1ObjectIdentifier encryptionOID, SecretKey encKey, SecureRandom rand) throws CRMFException {
        try {
            AlgorithmParameterGenerator pGen = this.g(encryptionOID);
            if (encryptionOID.equals(CMSAlgorithm.RC2_CBC)) {
                byte[] iv = new byte[8];
                rand.nextBytes(iv);
                try {
                    pGen.init(new RC2ParameterSpec(encKey.getEncoded().length << 3, iv), rand);
                }
                catch (InvalidAlgorithmParameterException e2) {
                    throw new CRMFException("parameters generation error: " + e2, e2);
                }
            }
            return pGen.generateParameters();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (GeneralSecurityException e3) {
            throw new CRMFException("exception creating algorithm parameter generator: " + e3, e3);
        }
    }

    AlgorithmIdentifier a(ASN1ObjectIdentifier encryptionOID, AlgorithmParameters params) throws CRMFException {
        ASN1Primitive asn1Params;
        if (params != null) {
            try {
                asn1Params = ASN1Primitive.fromByteArray(params.getEncoded("ASN.1"));
            }
            catch (IOException e2) {
                throw new CRMFException("cannot encode parameters: " + e2.getMessage(), e2);
            }
        } else {
            asn1Params = DERNull.INSTANCE;
        }
        return new AlgorithmIdentifier(encryptionOID, (ASN1Encodable)asn1Params);
    }

    static Object a(a callback) throws CRMFException {
        try {
            return callback.a();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new CRMFException("can't find algorithm.", e2);
        }
        catch (InvalidKeyException e3) {
            throw new CRMFException("key invalid in message.", e3);
        }
        catch (NoSuchProviderException e4) {
            throw new CRMFException("can't find provider.", e4);
        }
        catch (NoSuchPaddingException e5) {
            throw new CRMFException("required padding not supported.", e5);
        }
        catch (InvalidAlgorithmParameterException e6) {
            throw new CRMFException("algorithm parameters invalid.", e6);
        }
        catch (InvalidParameterSpecException e7) {
            throw new CRMFException("MAC algorithm parameter spec invalid.", e7);
        }
    }

    static {
        a.put(PKCSObjectIdentifiers.des_EDE3_CBC, "DESEDE");
        a.put(NISTObjectIdentifiers.id_aes128_CBC, "AES");
        a.put(NISTObjectIdentifiers.id_aes192_CBC, "AES");
        a.put(NISTObjectIdentifiers.id_aes256_CBC, "AES");
        b.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        b.put(CMSAlgorithm.AES128_CBC, "AES/CBC/PKCS5Padding");
        b.put(CMSAlgorithm.AES192_CBC, "AES/CBC/PKCS5Padding");
        b.put(CMSAlgorithm.AES256_CBC, "AES/CBC/PKCS5Padding");
        b.put(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId()), "RSA/ECB/PKCS1Padding");
        c.put(OIWObjectIdentifiers.idSHA1, "SHA1");
        c.put(NISTObjectIdentifiers.id_sha224, "SHA224");
        c.put(NISTObjectIdentifiers.id_sha256, "SHA256");
        c.put(NISTObjectIdentifiers.id_sha384, "SHA384");
        c.put(NISTObjectIdentifiers.id_sha512, "SHA512");
        e.put(IANAObjectIdentifiers.hmacSHA1, "HMACSHA1");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA1, "HMACSHA1");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA224, "HMACSHA224");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA256, "HMACSHA256");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA384, "HMACSHA384");
        e.put(PKCSObjectIdentifiers.id_hmacWithSHA512, "HMACSHA512");
        d.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        d.put(X9ObjectIdentifiers.id_dsa, "DSA");
    }

    static interface a {
        public Object a() throws CRMFException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException;
    }
}

