/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import com.timevale.tgtext.bouncycastle.crypto.digests.MD5Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA256Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA384Digest;
import com.timevale.tgtext.bouncycastle.crypto.engines.AESFastEngine;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESedeEngine;
import com.timevale.tgtext.bouncycastle.crypto.engines.RC4Engine;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipher;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsCipherFactory;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsStreamCipher;
import java.io.IOException;

public class DefaultTlsCipherFactory
implements TlsCipherFactory {
    @Override
    public TlsCipher createCipher(TlsClientContext context, int encryptionAlgorithm, int digestAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, 24, digestAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, digestAlgorithm);
            }
            case 9: {
                return this.createAESCipher(context, 32, digestAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(context, 16, digestAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsCipher createAESCipher(TlsClientContext context, int cipherKeySize, int digestAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createDigest(digestAlgorithm), this.createDigest(digestAlgorithm), cipherKeySize);
    }

    protected TlsCipher createRC4Cipher(TlsClientContext context, int cipherKeySize, int digestAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createDigest(digestAlgorithm), this.createDigest(digestAlgorithm), cipherKeySize);
    }

    protected TlsCipher createDESedeCipher(TlsClientContext context, int cipherKeySize, int digestAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createDigest(digestAlgorithm), this.createDigest(digestAlgorithm), cipherKeySize);
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected Digest createDigest(int digestAlgorithm) throws IOException {
        switch (digestAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

