/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jce.provider;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410Parameters;
import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.timevale.tgtext.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import com.timevale.tgtext.bouncycastle.jce.interfaces.GOST3410PublicKey;
import com.timevale.tgtext.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class GOST3410Util {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PublicKey) {
            GOST3410PublicKey k2 = (GOST3410PublicKey)key;
            GOST3410PublicKeyParameterSetSpec p2 = k2.getParameters().getPublicKeyParameters();
            return new GOST3410PublicKeyParameters(k2.getY(), new GOST3410Parameters(p2.getP(), p2.getQ(), p2.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PrivateKey) {
            GOST3410PrivateKey k2 = (GOST3410PrivateKey)key;
            GOST3410PublicKeyParameterSetSpec p2 = k2.getParameters().getPublicKeyParameters();
            return new GOST3410PrivateKeyParameters(k2.getX(), new GOST3410Parameters(p2.getP(), p2.getQ(), p2.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 private key.");
    }
}

