/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.openssl;

import com.timevale.tgtext.bouncycastle.openssl.PEMEncryptor;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import com.timevale.tgtext.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemGenerationException;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemObjectGenerator;
import com.timevale.tgtext.bouncycastle.util.io.pem.PemWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.SecureRandom;

public class PEMWriter
extends PemWriter {
    private String provider;

    public PEMWriter(Writer out) {
        this(out, "BC");
    }

    public PEMWriter(Writer out, String provider) {
        super(out);
        this.provider = provider;
    }

    public void writeObject(Object obj) throws IOException {
        this.writeObject(obj, null);
    }

    public void writeObject(Object obj, PEMEncryptor encryptor) throws IOException {
        try {
            super.writeObject(new JcaMiscPEMGenerator(obj, encryptor));
            return;
        }
        catch (PemGenerationException pemGenerationException) {
            PemGenerationException e2 = pemGenerationException;
            if (pemGenerationException.getCause() instanceof IOException) {
                throw (IOException)e2.getCause();
            }
            throw e2;
        }
    }

    @Override
    public void writeObject(PemObjectGenerator obj) throws IOException {
        super.writeObject(obj);
    }

    public void writeObject(Object obj, String algorithm, char[] password, SecureRandom random) throws IOException {
        this.writeObject(obj, new JcePEMEncryptorBuilder(algorithm).setSecureRandom(random).setProvider(this.provider).build(password));
    }
}

