/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.bc;

import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifier;
import com.timevale.tgtext.bouncycastle.operator.ContentVerifierProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.operator.bc.BcSignerOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BcContentVerifierProviderBuilder {
    public ContentVerifierProvider build(final X509CertificateHolder certHolder) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return certHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    AsymmetricKeyParameter publicKey = BcContentVerifierProviderBuilder.this.extractKeyParameters(certHolder.getSubjectPublicKeyInfo());
                    BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                    return new a(algorithm, stream);
                }
                catch (IOException e2) {
                    throw new OperatorCreationException("exception on setup: " + e2, e2);
                }
            }
        };
    }

    public ContentVerifierProvider build(final AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return false;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return null;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithm) throws OperatorCreationException {
                BcSignerOutputStream stream = BcContentVerifierProviderBuilder.this.createSignatureStream(algorithm, publicKey);
                return new a(algorithm, stream);
            }
        };
    }

    private BcSignerOutputStream createSignatureStream(AlgorithmIdentifier algorithm, AsymmetricKeyParameter publicKey) throws OperatorCreationException {
        Signer sig = this.createSigner(algorithm);
        sig.init(false, publicKey);
        return new BcSignerOutputStream(sig);
    }

    protected abstract AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo var1) throws IOException;

    protected abstract Signer createSigner(AlgorithmIdentifier var1) throws OperatorCreationException;

    private class a
    implements ContentVerifier {
        private BcSignerOutputStream b;
        private AlgorithmIdentifier c;

        a(AlgorithmIdentifier algorithm, BcSignerOutputStream stream) {
            this.c = algorithm;
            this.b = stream;
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.b == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.b;
        }

        @Override
        public boolean verify(byte[] expected) {
            return this.b.verify(expected);
        }
    }
}

