/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.operator.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.tgtext.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.NamedJcaJceHelper;
import com.timevale.tgtext.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.timevale.tgtext.bouncycastle.operator.AsymmetricKeyWrapper;
import com.timevale.tgtext.bouncycastle.operator.GenericKey;
import com.timevale.tgtext.bouncycastle.operator.OperatorException;
import com.timevale.tgtext.bouncycastle.operator.jcajce.a;
import com.timevale.tgtext.bouncycastle.operator.jcajce.b;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class JceAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private a helper = new a(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PublicKey publicKey;
    private SecureRandom random;

    public JceAsymmetricKeyWrapper(PublicKey publicKey) {
        super(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()).getAlgorithm());
        this.publicKey = publicKey;
    }

    public JceAsymmetricKeyWrapper(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    public JceAsymmetricKeyWrapper setProvider(Provider provider) {
        this.helper = new a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyWrapper setProvider(String providerName) {
        this.helper = new a(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceAsymmetricKeyWrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Cipher keyEncryptionCipher = this.helper.a(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        byte[] encryptedKeyBytes = null;
        try {
            keyEncryptionCipher.init(3, (Key)this.publicKey, this.random);
            encryptedKeyBytes = keyEncryptionCipher.wrap(b.a(encryptionKey));
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {}
        if (encryptedKeyBytes == null) {
            try {
                keyEncryptionCipher.init(1, (Key)this.publicKey, this.random);
                encryptedKeyBytes = keyEncryptionCipher.doFinal(b.a(encryptionKey).getEncoded());
            }
            catch (GeneralSecurityException e2) {
                throw new OperatorException("unable to encrypt contents key", e2);
            }
        }
        return encryptedKeyBytes;
    }
}

