/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.Layer;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;

public class RainbowPrivateKey
extends ASN1Object {
    private ASN1Integer version;
    private ASN1ObjectIdentifier oid;
    private byte[][] invA1;
    private byte[] b1;
    private byte[][] invA2;
    private byte[] b2;
    private byte[] vi;
    private Layer[] layers;

    private RainbowPrivateKey(ASN1Sequence seq) {
        if (seq.getObjectAt(0) instanceof ASN1Integer) {
            this.version = ASN1Integer.getInstance(seq.getObjectAt(0));
        } else {
            this.oid = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        }
        ASN1Sequence asnA1 = (ASN1Sequence)seq.getObjectAt(1);
        this.invA1 = new byte[asnA1.size()][];
        for (int i2 = 0; i2 < asnA1.size(); ++i2) {
            this.invA1[i2] = ((ASN1OctetString)asnA1.getObjectAt(i2)).getOctets();
        }
        ASN1Sequence asnb1 = (ASN1Sequence)seq.getObjectAt(2);
        this.b1 = ((ASN1OctetString)asnb1.getObjectAt(0)).getOctets();
        ASN1Sequence asnA2 = (ASN1Sequence)seq.getObjectAt(3);
        this.invA2 = new byte[asnA2.size()][];
        for (int j2 = 0; j2 < asnA2.size(); ++j2) {
            this.invA2[j2] = ((ASN1OctetString)asnA2.getObjectAt(j2)).getOctets();
        }
        ASN1Sequence asnb2 = (ASN1Sequence)seq.getObjectAt(4);
        this.b2 = ((ASN1OctetString)asnb2.getObjectAt(0)).getOctets();
        ASN1Sequence asnvi = (ASN1Sequence)seq.getObjectAt(5);
        this.vi = ((ASN1OctetString)asnvi.getObjectAt(0)).getOctets();
        ASN1Sequence asnLayers = (ASN1Sequence)seq.getObjectAt(6);
        byte[][][][] alphas = new byte[asnLayers.size()][][][];
        byte[][][][] betas = new byte[asnLayers.size()][][][];
        byte[][][] gammas = new byte[asnLayers.size()][][];
        byte[][] etas = new byte[asnLayers.size()][];
        for (int l2 = 0; l2 < asnLayers.size(); ++l2) {
            ASN1Sequence asnLayer = (ASN1Sequence)asnLayers.getObjectAt(l2);
            ASN1Sequence alphas3d = (ASN1Sequence)asnLayer.getObjectAt(0);
            alphas[l2] = new byte[alphas3d.size()][][];
            for (int m2 = 0; m2 < alphas3d.size(); ++m2) {
                ASN1Sequence alphas2d = (ASN1Sequence)alphas3d.getObjectAt(m2);
                alphas[l2][m2] = new byte[alphas2d.size()][];
                for (int n2 = 0; n2 < alphas2d.size(); ++n2) {
                    alphas[l2][m2][n2] = ((ASN1OctetString)alphas2d.getObjectAt(n2)).getOctets();
                }
            }
            ASN1Sequence betas3d = (ASN1Sequence)asnLayer.getObjectAt(1);
            betas[l2] = new byte[betas3d.size()][][];
            for (int mb = 0; mb < betas3d.size(); ++mb) {
                ASN1Sequence betas2d = (ASN1Sequence)betas3d.getObjectAt(mb);
                betas[l2][mb] = new byte[betas2d.size()][];
                for (int nb = 0; nb < betas2d.size(); ++nb) {
                    betas[l2][mb][nb] = ((ASN1OctetString)betas2d.getObjectAt(nb)).getOctets();
                }
            }
            ASN1Sequence gammas2d = (ASN1Sequence)asnLayer.getObjectAt(2);
            gammas[l2] = new byte[gammas2d.size()][];
            for (int mg = 0; mg < gammas2d.size(); ++mg) {
                gammas[l2][mg] = ((ASN1OctetString)gammas2d.getObjectAt(mg)).getOctets();
            }
            etas[l2] = ((ASN1OctetString)asnLayer.getObjectAt(3)).getOctets();
        }
        int numOfLayers = this.vi.length - 1;
        this.layers = new Layer[numOfLayers];
        for (int i3 = 0; i3 < numOfLayers; ++i3) {
            Layer l3;
            this.layers[i3] = l3 = new Layer(this.vi[i3], this.vi[i3 + 1], RainbowUtil.convertArray(alphas[i3]), RainbowUtil.convertArray(betas[i3]), RainbowUtil.convertArray(gammas[i3]), RainbowUtil.convertArray(etas[i3]));
        }
    }

    public RainbowPrivateKey(short[][] invA1, short[] b1, short[][] invA2, short[] b2, int[] vi, Layer[] layers) {
        this.version = new ASN1Integer(1L);
        this.invA1 = RainbowUtil.convertArray(invA1);
        this.b1 = RainbowUtil.convertArray(b1);
        this.invA2 = RainbowUtil.convertArray(invA2);
        this.b2 = RainbowUtil.convertArray(b2);
        this.vi = RainbowUtil.convertIntArray(vi);
        this.layers = layers;
    }

    public static RainbowPrivateKey getInstance(Object o2) {
        if (o2 instanceof RainbowPrivateKey) {
            return (RainbowPrivateKey)o2;
        }
        if (o2 != null) {
            return new RainbowPrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public short[][] getInvA1() {
        return RainbowUtil.convertArray(this.invA1);
    }

    public short[] getB1() {
        return RainbowUtil.convertArray(this.b1);
    }

    public short[] getB2() {
        return RainbowUtil.convertArray(this.b2);
    }

    public short[][] getInvA2() {
        return RainbowUtil.convertArray(this.invA2);
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public int[] getVi() {
        return RainbowUtil.convertArraytoInt(this.vi);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.version != null) {
            v2.add(this.version);
        } else {
            v2.add(this.oid);
        }
        ASN1EncodableVector asnA1 = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.invA1.length; ++i2) {
            asnA1.add(new DEROctetString(this.invA1[i2]));
        }
        v2.add(new DERSequence(asnA1));
        ASN1EncodableVector asnb1 = new ASN1EncodableVector();
        asnb1.add(new DEROctetString(this.b1));
        v2.add(new DERSequence(asnb1));
        ASN1EncodableVector asnA2 = new ASN1EncodableVector();
        for (int i3 = 0; i3 < this.invA2.length; ++i3) {
            asnA2.add(new DEROctetString(this.invA2[i3]));
        }
        v2.add(new DERSequence(asnA2));
        ASN1EncodableVector asnb2 = new ASN1EncodableVector();
        asnb2.add(new DEROctetString(this.b2));
        v2.add(new DERSequence(asnb2));
        ASN1EncodableVector asnvi = new ASN1EncodableVector();
        asnvi.add(new DEROctetString(this.vi));
        v2.add(new DERSequence(asnvi));
        ASN1EncodableVector asnLayers = new ASN1EncodableVector();
        for (int l2 = 0; l2 < this.layers.length; ++l2) {
            ASN1EncodableVector aLayer = new ASN1EncodableVector();
            byte[][][] alphas = RainbowUtil.convertArray(this.layers[l2].getCoeffAlpha());
            ASN1EncodableVector alphas3d = new ASN1EncodableVector();
            for (int i4 = 0; i4 < alphas.length; ++i4) {
                ASN1EncodableVector alphas2d = new ASN1EncodableVector();
                for (int j2 = 0; j2 < alphas[i4].length; ++j2) {
                    alphas2d.add(new DEROctetString(alphas[i4][j2]));
                }
                alphas3d.add(new DERSequence(alphas2d));
            }
            aLayer.add(new DERSequence(alphas3d));
            byte[][][] betas = RainbowUtil.convertArray(this.layers[l2].getCoeffBeta());
            ASN1EncodableVector betas3d = new ASN1EncodableVector();
            for (int i5 = 0; i5 < betas.length; ++i5) {
                ASN1EncodableVector betas2d = new ASN1EncodableVector();
                for (int j3 = 0; j3 < betas[i5].length; ++j3) {
                    betas2d.add(new DEROctetString(betas[i5][j3]));
                }
                betas3d.add(new DERSequence(betas2d));
            }
            aLayer.add(new DERSequence(betas3d));
            byte[][] gammas = RainbowUtil.convertArray(this.layers[l2].getCoeffGamma());
            ASN1EncodableVector asnG = new ASN1EncodableVector();
            for (int i6 = 0; i6 < gammas.length; ++i6) {
                asnG.add(new DEROctetString(gammas[i6]));
            }
            aLayer.add(new DERSequence(asnG));
            aLayer.add(new DEROctetString(RainbowUtil.convertArray(this.layers[l2].getCoeffEta())));
            asnLayers.add(new DERSequence(aLayer));
        }
        v2.add(new DERSequence(asnLayers));
        return new DERSequence(v2);
    }
}

