/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.rainbow;

import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class RainbowKeysToParams {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof BCRainbowPublicKey) {
            BCRainbowPublicKey k2 = (BCRainbowPublicKey)key;
            return new RainbowPublicKeyParameters(k2.getDocLength(), k2.getCoeffQuadratic(), k2.getCoeffSingular(), k2.getCoeffScalar());
        }
        throw new InvalidKeyException("can't identify Rainbow public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof BCRainbowPrivateKey) {
            BCRainbowPrivateKey k2 = (BCRainbowPrivateKey)key;
            return new RainbowPrivateKeyParameters(k2.getInvA1(), k2.getB1(), k2.getInvA2(), k2.getB2(), k2.getVi(), k2.getLayers());
        }
        throw new InvalidKeyException("can't identify Rainbow private key.");
    }
}

