/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Polynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nONBElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomial;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2nPolynomialElement;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.util.Random;
import java.util.Vector;

public class GF2nONBField
extends GF2nField {
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private int mType;
    int[][] mMult;

    public GF2nONBField(int deg) throws RuntimeException {
        if (deg < 3) {
            throw new IllegalArgumentException("k must be at least 3");
        }
        this.mDegree = deg;
        this.mLength = this.mDegree / 64;
        this.mBit = this.mDegree & 0x3F;
        if (this.mBit == 0) {
            this.mBit = 64;
        } else {
            ++this.mLength;
        }
        this.computeType();
        if (this.mType < 3) {
            this.mMult = new int[this.mDegree][2];
            for (int i2 = 0; i2 < this.mDegree; ++i2) {
                this.mMult[i2][0] = -1;
                this.mMult[i2][1] = -1;
            }
        } else {
            throw new RuntimeException("\nThe type of this field is " + this.mType);
        }
        this.computeMultMatrix();
        this.computeFieldPolynomial();
        this.fields = new Vector();
        this.matrices = new Vector();
    }

    int getONBLength() {
        return this.mLength;
    }

    int getONBBit() {
        return this.mBit;
    }

    @Override
    protected GF2nElement getRandomRoot(GF2Polynomial polynomial) {
        GF2nPolynomial g2 = new GF2nPolynomial(polynomial, this);
        int gDegree = g2.getDegree();
        while (gDegree > 1) {
            GF2nPolynomial h2;
            int hDegree;
            do {
                GF2nONBElement u2 = new GF2nONBElement(this, new Random());
                GF2nPolynomial ut = new GF2nPolynomial(2, GF2nONBElement.ZERO(this));
                ut.set(1, u2);
                GF2nPolynomial c2 = new GF2nPolynomial(ut);
                for (int i2 = 1; i2 <= this.mDegree - 1; ++i2) {
                    c2 = c2.multiplyAndReduce(c2, g2);
                    c2 = c2.add(ut);
                }
                h2 = c2.gcd(g2);
                hDegree = h2.getDegree();
                gDegree = g2.getDegree();
            } while (hDegree == 0 || hDegree == gDegree);
            g2 = hDegree << 1 > gDegree ? g2.quotient(h2) : new GF2nPolynomial(h2);
            gDegree = g2.getDegree();
        }
        return g2.at(0);
    }

    @Override
    protected void computeCOBMatrix(GF2nField B1) {
        GF2nElement u2;
        int i2;
        if (this.mDegree != B1.mDegree) {
            throw new IllegalArgumentException("GF2nField.computeCOBMatrix: B1 has a different degree and thus cannot be coverted to!");
        }
        GF2Polynomial[] COBMatrix = new GF2Polynomial[this.mDegree];
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            COBMatrix[i2] = new GF2Polynomial(this.mDegree);
        }
        while ((u2 = B1.getRandomRoot(this.fieldPolynomial)).isZero()) {
        }
        GF2nPolynomialElement[] gF2nPolynomialElementArray = new GF2nPolynomialElement[this.mDegree];
        GF2nPolynomialElement[] gamma = gF2nPolynomialElementArray;
        gF2nPolynomialElementArray[0] = (GF2nElement)u2.clone();
        for (i2 = 1; i2 < this.mDegree; ++i2) {
            gamma[i2] = ((GF2nElement)gamma[i2 - 1]).square();
        }
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            for (int j2 = 0; j2 < this.mDegree; ++j2) {
                if (!((GF2nElement)gamma[i2]).testBit(j2)) continue;
                COBMatrix[this.mDegree - j2 - 1].setBit(this.mDegree - i2 - 1);
            }
        }
        this.fields.addElement(B1);
        this.matrices.addElement(COBMatrix);
        B1.fields.addElement(this);
        B1.matrices.addElement(this.invertMatrix(COBMatrix));
    }

    @Override
    protected void computeFieldPolynomial() {
        if (this.mType == 1) {
            this.fieldPolynomial = new GF2Polynomial(this.mDegree + 1, "ALL");
            return;
        }
        if (this.mType == 2) {
            GF2Polynomial q2 = new GF2Polynomial(this.mDegree + 1, "ONE");
            GF2Polynomial p2 = new GF2Polynomial(this.mDegree + 1, "X");
            p2.addToThis(q2);
            for (int i2 = 1; i2 < this.mDegree; ++i2) {
                GF2Polynomial r2 = q2;
                q2 = p2;
                p2 = q2.shiftLeft();
                p2.addToThis(r2);
            }
            this.fieldPolynomial = p2;
        }
    }

    int[][] invMatrix(int[][] a2) {
        int i2;
        int[][] A = a2;
        int[][] inv = new int[this.mDegree][this.mDegree];
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            inv[i2][i2] = 1;
        }
        for (i2 = 0; i2 < this.mDegree; ++i2) {
            for (int j2 = i2; j2 < this.mDegree; ++j2) {
                A[this.mDegree - 1 - i2][j2] = A[i2][i2];
            }
        }
        return null;
    }

    private void computeType() throws RuntimeException {
        int k2;
        int s2;
        if ((this.mDegree & 7) == 0) {
            throw new RuntimeException("The extension degree is divisible by 8!");
        }
        this.mType = 1;
        int d2 = 0;
        while (d2 != 1) {
            s2 = this.mType * this.mDegree + 1;
            if (IntegerFunctions.isPrime(s2)) {
                k2 = IntegerFunctions.order(2, s2);
                d2 = IntegerFunctions.gcd(this.mType * this.mDegree / k2, this.mDegree);
            }
            ++this.mType;
        }
        --this.mType;
        if (this.mType == 1 && IntegerFunctions.isPrime(s2 = (this.mDegree << 1) + 1) && (d2 = IntegerFunctions.gcd((this.mDegree << 1) / (k2 = IntegerFunctions.order(2, s2)), this.mDegree)) == 1) {
            ++this.mType;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeMultMatrix() {
        int k2;
        if ((this.mType & 7) == 0) throw new RuntimeException("bisher nur fuer Gausssche Normalbasen implementiert");
        int p2 = this.mType * this.mDegree + 1;
        int[] F = new int[p2];
        int u2 = this.mType == 1 ? 1 : (this.mType == 2 ? p2 - 1 : this.elementOfOrder(this.mType, p2));
        int w2 = 1;
        for (int j2 = 0; j2 < this.mType; ++j2) {
            int n2 = w2;
            for (int i2 = 0; i2 < this.mDegree; ++i2) {
                F[n2] = i2;
                if ((n2 = (n2 << 1) % p2) >= 0) continue;
                n2 += p2;
            }
            if ((w2 = u2 * w2 % p2) >= 0) continue;
            w2 += p2;
        }
        if (this.mType == 1) {
            for (k2 = 1; k2 < p2 - 1; ++k2) {
                if (this.mMult[F[k2 + 1]][0] == -1) {
                    this.mMult[F[k2 + 1]][0] = F[p2 - k2];
                    continue;
                }
                this.mMult[F[k2 + 1]][1] = F[p2 - k2];
            }
            int m_2 = this.mDegree >> 1;
            for (int k3 = 1; k3 <= m_2; ++k3) {
                if (this.mMult[k3 - 1][0] == -1) {
                    this.mMult[k3 - 1][0] = m_2 + k3 - 1;
                } else {
                    this.mMult[k3 - 1][1] = m_2 + k3 - 1;
                }
                if (this.mMult[m_2 + k3 - 1][0] == -1) {
                    this.mMult[m_2 + k3 - 1][0] = k3 - 1;
                    continue;
                }
                this.mMult[m_2 + k3 - 1][1] = k3 - 1;
            }
            return;
        } else {
            if (this.mType != 2) throw new RuntimeException("only type 1 or type 2 implemented");
            for (k2 = 1; k2 < p2 - 1; ++k2) {
                if (this.mMult[F[k2 + 1]][0] == -1) {
                    this.mMult[F[k2 + 1]][0] = F[p2 - k2];
                    continue;
                }
                this.mMult[F[k2 + 1]][1] = F[p2 - k2];
            }
        }
    }

    private int elementOfOrder(int k2, int p2) {
        Random random = new Random();
        int m2 = 0;
        while (m2 == 0) {
            m2 = random.nextInt();
            if ((m2 %= p2 - 1) >= 0) continue;
            m2 += p2 - 1;
        }
        int l2 = IntegerFunctions.order(m2, p2);
        while (l2 % k2 != 0 || l2 == 0) {
            while (m2 == 0) {
                m2 = random.nextInt();
                if ((m2 %= p2 - 1) >= 0) continue;
                m2 += p2 - 1;
            }
            l2 = IntegerFunctions.order(m2, p2);
        }
        int r2 = m2;
        l2 = k2 / l2;
        for (int i2 = 2; i2 <= l2; ++i2) {
            r2 *= m2;
        }
        return r2;
    }
}

