/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertPolicyId;
import java.util.Enumeration;
import java.util.Hashtable;

public class PolicyMappings
extends ASN1Object {
    ASN1Sequence seq = null;

    public static PolicyMappings getInstance(Object obj) {
        if (obj instanceof PolicyMappings) {
            return (PolicyMappings)obj;
        }
        if (obj != null) {
            return new PolicyMappings(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PolicyMappings(ASN1Sequence seq) {
        this.seq = seq;
    }

    public PolicyMappings(Hashtable mappings) {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        Enumeration it = mappings.keys();
        while (it.hasMoreElements()) {
            String idp = (String)it.nextElement();
            String sdp = (String)mappings.get(idp);
            ASN1EncodableVector dv2 = new ASN1EncodableVector();
            dv2.add(new ASN1ObjectIdentifier(idp));
            dv2.add(new ASN1ObjectIdentifier(sdp));
            dev.add(new DERSequence(dv2));
        }
        this.seq = new DERSequence(dev);
    }

    public PolicyMappings(CertPolicyId issuerDomainPolicy, CertPolicyId subjectDomainPolicy) {
        ASN1EncodableVector dv2 = new ASN1EncodableVector();
        dv2.add(issuerDomainPolicy);
        dv2.add(subjectDomainPolicy);
        this.seq = new DERSequence(new DERSequence(dv2));
    }

    public PolicyMappings(CertPolicyId[] issuerDomainPolicy, CertPolicyId[] subjectDomainPolicy) {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        for (int i2 = 0; i2 != issuerDomainPolicy.length; ++i2) {
            ASN1EncodableVector dv2 = new ASN1EncodableVector();
            dv2.add(issuerDomainPolicy[i2]);
            dv2.add(subjectDomainPolicy[i2]);
            dev.add(new DERSequence(dv2));
        }
        this.seq = new DERSequence(dev);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

