/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.jcajce.provider.digest;

import com.timevale.tgtext.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.tgtext.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.timevale.tgtext.bouncycastle.jcajce.provider.digest.a;
import com.timevale.tgtext.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.timevale.tgtext.bouncycastle.jce.provider.JCEMac;

public class SHA1 {

    public static class Mappings
    extends a {
        private static final String PREFIX = SHA1.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-1", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA1", "SHA-1");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA", "SHA-1");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + OIWObjectIdentifiers.idSHA1, "SHA-1");
            this.addHMACAlgorithm(provider, "SHA1", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
            this.addHMACAlias(provider, "SHA1", IANAObjectIdentifiers.hmacSHA1);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA1", 160, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new SHA1Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA1Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d2 = (Digest)super.clone();
            ((Digest)super.clone()).digest = new SHA1Digest((SHA1Digest)this.digest);
            return d2;
        }
    }
}

