/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.examples;

import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.engines.DESedeEngine;
import com.timevale.tgtext.bouncycastle.crypto.generators.DESedeKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;

public class DESExample {
    private boolean encrypt = true;
    private PaddedBufferedBlockCipher cipher = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private byte[] key = null;

    public static void main(String[] args) {
        DESExample de2;
        boolean encrypt = true;
        if (args.length < 2) {
            de2 = new DESExample();
            System.err.println("Usage: java " + de2.getClass().getName() + " infile outfile [keyfile]");
            System.exit(1);
        }
        String keyfile = "deskey.dat";
        String infile = args[0];
        String outfile = args[1];
        if (args.length > 2) {
            encrypt = false;
            keyfile = args[2];
        }
        de2 = new DESExample(infile, outfile, keyfile, encrypt);
        de2.process();
    }

    public DESExample() {
    }

    public DESExample(String infile, String outfile, String keyfile, boolean encrypt) {
        this.encrypt = encrypt;
        try {
            this.in = new BufferedInputStream(new FileInputStream(infile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Input file not found [" + infile + "]");
            System.exit(1);
        }
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(outfile));
        }
        catch (IOException iOException) {
            System.err.println("Output file not created [" + outfile + "]");
            System.exit(1);
        }
        if (encrypt) {
            try {
                SecureRandom sr = null;
                try {
                    sr = new SecureRandom();
                    sr.setSeed("www.bouncycastle.org".getBytes());
                }
                catch (Exception exception) {
                    System.err.println("Hmmm, no SHA1PRNG, you need the Sun implementation");
                    System.exit(1);
                }
                KeyGenerationParameters kgp = new KeyGenerationParameters(sr, 192);
                DESedeKeyGenerator kg = new DESedeKeyGenerator();
                kg.init(kgp);
                this.key = kg.generateKey();
                BufferedOutputStream keystream = new BufferedOutputStream(new FileOutputStream(keyfile));
                byte[] keyhex = Hex.encode(this.key);
                keystream.write(keyhex, 0, keyhex.length);
                keystream.flush();
                keystream.close();
                return;
            }
            catch (IOException iOException) {
                System.err.println("Could not decryption create key file [" + keyfile + "]");
                System.exit(1);
                return;
            }
        }
        try {
            BufferedInputStream keystream = new BufferedInputStream(new FileInputStream(keyfile));
            int len = keystream.available();
            byte[] keyhex = new byte[len];
            keystream.read(keyhex, 0, len);
            this.key = Hex.decode(keyhex);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Decryption key file not found, or not valid [" + keyfile + "]");
            System.exit(1);
            return;
        }
    }

    private void process() {
        this.cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new DESedeEngine()));
        if (this.encrypt) {
            this.performEncrypt(this.key);
        } else {
            this.performDecrypt(this.key);
        }
        try {
            this.in.close();
            this.out.flush();
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void performEncrypt(byte[] key) {
        this.cipher.init(true, new KeyParameter(key));
        int outBlockSize = this.cipher.getOutputSize(47);
        byte[] inblock = new byte[47];
        byte[] outblock = new byte[outBlockSize];
        try {
            byte[] rv;
            int outL;
            int inL;
            while ((inL = this.in.read(inblock, 0, 47)) > 0) {
                outL = this.cipher.processBytes(inblock, 0, inL, outblock, 0);
                if (outL <= 0) continue;
                rv = Hex.encode(outblock, 0, outL);
                this.out.write(rv, 0, rv.length);
                this.out.write(10);
            }
            try {
                outL = this.cipher.doFinal(outblock, 0);
                if (outL > 0) {
                    rv = Hex.encode(outblock, 0, outL);
                    this.out.write(rv, 0, rv.length);
                    this.out.write(10);
                }
            }
            catch (CryptoException cryptoException) {
                return;
            }
        }
        catch (IOException iOException) {
            IOException ioeread = iOException;
            iOException.printStackTrace();
        }
    }

    private void performDecrypt(byte[] key) {
        this.cipher.init(false, new KeyParameter(key));
        BufferedReader br2 = new BufferedReader(new InputStreamReader(this.in));
        try {
            int outL;
            String rv;
            byte[] outblock = null;
            while ((rv = br2.readLine()) != null) {
                byte[] inblock = Hex.decode(rv);
                outL = this.cipher.processBytes(inblock, 0, inblock.length, outblock = new byte[this.cipher.getOutputSize(inblock.length)], 0);
                if (outL <= 0) continue;
                this.out.write(outblock, 0, outL);
            }
            try {
                outL = this.cipher.doFinal(outblock, 0);
                if (outL > 0) {
                    this.out.write(outblock, 0, outL);
                }
            }
            catch (CryptoException cryptoException) {
                return;
            }
        }
        catch (IOException iOException) {
            IOException ioeread = iOException;
            iOException.printStackTrace();
        }
    }
}

