/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

public final class ByteUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            result &= left[i2] == right[i2];
        }
        return result;
    }

    public static boolean equals(byte[][] left, byte[][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            result &= ByteUtils.equals(left[i2], right[i2]);
        }
        return result;
    }

    public static boolean equals(byte[][][] left, byte[][][] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            if (left[i2].length != right[i2].length) {
                return false;
            }
            for (int j2 = left[i2].length - 1; j2 >= 0; --j2) {
                result &= ByteUtils.equals(left[i2][j2], right[i2][j2]);
            }
        }
        return result;
    }

    public static int deepHashCode(byte[] array) {
        int result = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            result = result * 31 + array[i2];
        }
        return result;
    }

    public static int deepHashCode(byte[][] array) {
        int result = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            result = result * 31 + ByteUtils.deepHashCode(array[i2]);
        }
        return result;
    }

    public static int deepHashCode(byte[][][] array) {
        int result = 1;
        for (int i2 = 0; i2 < array.length; ++i2) {
            result = result * 31 + ByteUtils.deepHashCode(array[i2]);
        }
        return result;
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        byte[] result = new byte[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static byte[] fromHexString(String s2) {
        char[] rawChars = s2.toUpperCase().toCharArray();
        int hexChars = 0;
        for (int i2 = 0; i2 < rawChars.length; ++i2) {
            if ((rawChars[i2] < '0' || rawChars[i2] > '9') && (rawChars[i2] < 'A' || rawChars[i2] > 'F')) continue;
            ++hexChars;
        }
        byte[] byteString = new byte[hexChars + 1 >> 1];
        int pos = hexChars & 1;
        for (int i3 = 0; i3 < rawChars.length; ++i3) {
            if (rawChars[i3] >= '0' && rawChars[i3] <= '9') {
                int n2 = pos >> 1;
                byteString[n2] = (byte)(byteString[n2] << 4);
                int n3 = pos >> 1;
                byteString[n3] = (byte)(byteString[n3] | rawChars[i3] - 48);
            } else {
                if (rawChars[i3] < 'A' || rawChars[i3] > 'F') continue;
                int n4 = pos >> 1;
                byteString[n4] = (byte)(byteString[n4] << 4);
                int n5 = pos >> 1;
                byteString[n5] = (byte)(byteString[n5] | rawChars[i3] - 65 + 10);
            }
            ++pos;
        }
        return byteString;
    }

    public static String toHexString(byte[] input) {
        String result = "";
        for (int i2 = 0; i2 < input.length; ++i2) {
            result = result + HEX_CHARS[input[i2] >>> 4 & 0xF];
            result = result + HEX_CHARS[input[i2] & 0xF];
        }
        return result;
    }

    public static String toHexString(byte[] input, String prefix, String seperator) {
        String result = new String(prefix);
        for (int i2 = 0; i2 < input.length; ++i2) {
            result = result + HEX_CHARS[input[i2] >>> 4 & 0xF];
            result = result + HEX_CHARS[input[i2] & 0xF];
            if (i2 >= input.length - 1) continue;
            result = result + seperator;
        }
        return result;
    }

    public static String toBinaryString(byte[] input) {
        String result = "";
        for (int i2 = 0; i2 < input.length; ++i2) {
            byte e2 = input[i2];
            for (int ii = 0; ii < 8; ++ii) {
                int b2 = e2 >>> ii & 1;
                result = result + b2;
            }
            if (i2 == input.length - 1) continue;
            result = result + " ";
        }
        return result;
    }

    public static byte[] xor(byte[] x1, byte[] x2) {
        byte[] out = new byte[x1.length];
        for (int i2 = x1.length - 1; i2 >= 0; --i2) {
            out[i2] = (byte)(x1[i2] ^ x2[i2]);
        }
        return out;
    }

    public static byte[] concatenate(byte[] x1, byte[] x2) {
        byte[] result = new byte[x1.length + x2.length];
        System.arraycopy(x1, 0, result, 0, x1.length);
        System.arraycopy(x2, 0, result, x1.length, x2.length);
        return result;
    }

    public static byte[] concatenate(byte[][] array) {
        int rowLength = array[0].length;
        byte[] result = new byte[array.length * rowLength];
        int index = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            System.arraycopy(array[i2], 0, result, index, rowLength);
            index += rowLength;
        }
        return result;
    }

    public static byte[][] split(byte[] input, int index) throws ArrayIndexOutOfBoundsException {
        if (index > input.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] byArrayArray = new byte[2][];
        byte[][] result = byArrayArray;
        byArrayArray[0] = new byte[index];
        result[1] = new byte[input.length - index];
        System.arraycopy(input, 0, result[0], 0, index);
        System.arraycopy(input, index, result[1], 0, input.length - index);
        return result;
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static byte[] subArray(byte[] input, int start) {
        return ByteUtils.subArray(input, start, input.length);
    }

    public static char[] toCharArray(byte[] input) {
        char[] result = new char[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            result[i2] = (char)input[i2];
        }
        return result;
    }
}

