/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.RandUtils;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Vector;
import java.security.SecureRandom;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int length) {
        if (length < 0) {
            throw new ArithmeticException("Negative length.");
        }
        this.length = length;
        this.v = new int[length + 31 >> 5];
    }

    public GF2Vector(int length, SecureRandom sr) {
        this.length = length;
        int size = length + 31 >> 5;
        this.v = new int[size];
        for (int i2 = size - 1; i2 >= 0; --i2) {
            this.v[i2] = sr.nextInt();
        }
        int r2 = length & 0x1F;
        if (r2 != 0) {
            int n2 = size - 1;
            this.v[n2] = this.v[n2] & (1 << r2) - 1;
        }
    }

    public GF2Vector(int length, int t2, SecureRandom sr) {
        if (t2 > length) {
            throw new ArithmeticException("The hamming weight is greater than the length of vector.");
        }
        this.length = length;
        int size = length + 31 >> 5;
        this.v = new int[size];
        int[] help = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            help[i2] = i2;
        }
        int m2 = length;
        for (int i3 = 0; i3 < t2; ++i3) {
            int j2 = RandUtils.nextInt(sr, m2);
            this.setBit(help[j2]);
            help[j2] = help[--m2];
        }
    }

    public GF2Vector(int length, int[] v2) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        this.length = length;
        int size = length + 31 >> 5;
        if (v2.length != size) {
            throw new ArithmeticException("length mismatch");
        }
        this.v = IntUtils.clone(v2);
        int r2 = length & 0x1F;
        if (r2 != 0) {
            int n2 = size - 1;
            this.v[n2] = this.v[n2] & (1 << r2) - 1;
        }
    }

    public GF2Vector(GF2Vector other) {
        this.length = other.length;
        this.v = IntUtils.clone(other.v);
    }

    protected GF2Vector(int[] v2, int length) {
        this.v = v2;
        this.length = length;
    }

    public static GF2Vector OS2VP(int length, byte[] encVec) {
        if (length < 0) {
            throw new ArithmeticException("negative length");
        }
        int byteLen = length + 7 >> 3;
        if (encVec.length > byteLen) {
            throw new ArithmeticException("length mismatch");
        }
        return new GF2Vector(length, LittleEndianConversions.toIntArray(encVec));
    }

    @Override
    public byte[] getEncoded() {
        int byteLen = this.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(this.v, byteLen);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int weight = 0;
        for (int i2 = 0; i2 < this.v.length; ++i2) {
            int e2 = this.v[i2];
            for (int j2 = 0; j2 < 32; ++j2) {
                int b2 = e2 & 1;
                if (b2 != 0) {
                    ++weight;
                }
                e2 >>>= 1;
            }
        }
        return weight;
    }

    @Override
    public boolean isZero() {
        for (int i2 = this.v.length - 1; i2 >= 0; --i2) {
            if (this.v[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public int getBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int q2 = index >> 5;
        int r2 = index & 0x1F;
        return (this.v[q2] & 1 << r2) >>> r2;
    }

    public void setBit(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = index >> 5;
        this.v[n2] = this.v[n2] | 1 << (index & 0x1F);
    }

    @Override
    public Vector add(Vector other) {
        if (!(other instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        GF2Vector otherVec = (GF2Vector)other;
        if (this.length != otherVec.length) {
            throw new ArithmeticException("length mismatch");
        }
        int[] vec = IntUtils.clone(((GF2Vector)other).v);
        for (int i2 = vec.length - 1; i2 >= 0; --i2) {
            int n2 = i2;
            vec[n2] = vec[n2] ^ this.v[i2];
        }
        return new GF2Vector(this.length, vec);
    }

    @Override
    public Vector multiply(Permutation p2) {
        int[] pVec = p2.getVector();
        if (this.length != pVec.length) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Vector result = new GF2Vector(this.length);
        for (int i2 = 0; i2 < pVec.length; ++i2) {
            int e2 = this.v[pVec[i2] >> 5] & 1 << (pVec[i2] & 0x1F);
            if (e2 == 0) continue;
            int n2 = i2 >> 5;
            result.v[n2] = result.v[n2] | 1 << (i2 & 0x1F);
        }
        return result;
    }

    public GF2Vector extractVector(int[] setJ) {
        int k2 = setJ.length;
        if (setJ[k2 - 1] > this.length) {
            throw new ArithmeticException("invalid index set");
        }
        GF2Vector result = new GF2Vector(k2);
        for (int i2 = 0; i2 < k2; ++i2) {
            int e2 = this.v[setJ[i2] >> 5] & 1 << (setJ[i2] & 0x1F);
            if (e2 == 0) continue;
            int n2 = i2 >> 5;
            result.v[n2] = result.v[n2] | 1 << (i2 & 0x1F);
        }
        return result;
    }

    public GF2Vector extractLeftVector(int k2) {
        if (k2 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k2 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector result = new GF2Vector(k2);
        int q2 = k2 >> 5;
        int r2 = k2 & 0x1F;
        System.arraycopy(this.v, 0, result.v, 0, q2);
        if (r2 != 0) {
            result.v[q2] = this.v[q2] & (1 << r2) - 1;
        }
        return result;
    }

    public GF2Vector extractRightVector(int k2) {
        if (k2 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (k2 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector result = new GF2Vector(k2);
        int q2 = this.length - k2 >> 5;
        int r2 = this.length - k2 & 0x1F;
        int length = k2 + 31 >> 5;
        int ind = q2;
        if (r2 != 0) {
            for (int i2 = 0; i2 < length - 1; ++i2) {
                result.v[i2] = this.v[ind++] >>> r2 | this.v[ind] << 32 - r2;
            }
            result.v[length - 1] = this.v[ind++] >>> r2;
            if (ind < this.v.length) {
                int n2 = length - 1;
                result.v[n2] = result.v[n2] | this.v[ind] << 32 - r2;
            }
        } else {
            System.arraycopy(this.v, q2, result.v, 0, length);
        }
        return result;
    }

    public GF2mVector toExtensionFieldVector(GF2mField field) {
        int m2 = field.getDegree();
        if (this.length % m2 != 0) {
            throw new ArithmeticException("conversion is impossible");
        }
        int t2 = this.length / m2;
        int[] result = new int[t2];
        int count = 0;
        for (int i2 = t2 - 1; i2 >= 0; --i2) {
            for (int j2 = field.getDegree() - 1; j2 >= 0; --j2) {
                int q2 = count >>> 5;
                int r2 = count & 0x1F;
                int e2 = this.v[q2] >>> r2 & 1;
                if (e2 == 1) {
                    int n2 = i2;
                    result[n2] = result[n2] ^ 1 << j2;
                }
                ++count;
            }
        }
        return new GF2mVector(field, result);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GF2Vector)) {
            return false;
        }
        GF2Vector otherVec = (GF2Vector)other;
        return this.length == otherVec.length && IntUtils.equals(this.v, otherVec.v);
    }

    @Override
    public int hashCode() {
        int hash = this.length;
        hash = hash * 31 + this.v.hashCode();
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.length; ++i2) {
            int r2;
            int q2;
            int bit;
            if (i2 != 0 && (i2 & 0x1F) == 0) {
                buf.append(' ');
            }
            if ((bit = this.v[q2 = i2 >> 5] & 1 << (r2 = i2 & 0x1F)) == 0) {
                buf.append('0');
                continue;
            }
            buf.append('1');
        }
        return buf.toString();
    }
}

