/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.tgtext.bouncycastle.asn1.ess.ESSCertID;
import com.timevale.tgtext.bouncycastle.asn1.ess.ESSCertIDv2;
import com.timevale.tgtext.bouncycastle.asn1.ess.SigningCertificate;
import com.timevale.tgtext.bouncycastle.asn1.ess.SigningCertificateV2;
import com.timevale.tgtext.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TSTInfo;
import com.timevale.tgtext.bouncycastle.asn1.x500.X500Name;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuerSerial;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Name;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.cms.SignerId;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationVerifier;
import com.timevale.tgtext.bouncycastle.jce.PrincipalUtil;
import com.timevale.tgtext.bouncycastle.jce.X509Principal;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TSPUtil;
import com.timevale.tgtext.bouncycastle.tsp.TSPValidationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;

public class TimeStampToken {
    CMSSignedData tsToken;
    SignerInformation tsaSignerInfo;
    Date genTime;
    TimeStampTokenInfo tstInfo;
    a certID;

    public TimeStampToken(ContentInfo contentInfo) throws TSPException, IOException {
        this(TimeStampToken.getSignedData(contentInfo));
    }

    private static CMSSignedData getSignedData(ContentInfo contentInfo) throws TSPException {
        try {
            return new CMSSignedData(contentInfo);
        }
        catch (CMSException e2) {
            throw new TSPException("TSP parsing error: " + e2.getMessage(), e2.getCause());
        }
    }

    public TimeStampToken(CMSSignedData signedData) throws TSPException, IOException {
        this.tsToken = signedData;
        if (!this.tsToken.getSignedContentTypeOID().equals(PKCSObjectIdentifiers.id_ct_TSTInfo.getId())) {
            throw new TSPValidationException("ContentInfo object not for a time stamp.");
        }
        Collection signers = this.tsToken.getSignerInfos().getSigners();
        if (signers.size() != 1) {
            throw new IllegalArgumentException("Time-stamp token signed by " + signers.size() + " signers, but it must contain just the TSA signature.");
        }
        this.tsaSignerInfo = (SignerInformation)signers.iterator().next();
        try {
            CMSTypedData content = this.tsToken.getSignedContent();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            content.write(bOut);
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(bOut.toByteArray()));
            this.tstInfo = new TimeStampTokenInfo(TSTInfo.getInstance(aIn.readObject()));
            Attribute attr = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (attr == null) {
                attr = this.tsaSignerInfo.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (attr == null) {
                    throw new TSPValidationException("no signing certificate attribute found, time stamp invalid.");
                }
                SigningCertificateV2 signCertV2 = SigningCertificateV2.getInstance(attr.getAttrValues().getObjectAt(0));
                this.certID = new a(ESSCertIDv2.getInstance(signCertV2.getCerts()[0]));
                return;
            }
            SigningCertificate signCert = SigningCertificate.getInstance(attr.getAttrValues().getObjectAt(0));
            this.certID = new a(ESSCertID.getInstance(signCert.getCerts()[0]));
        }
        catch (CMSException e2) {
            throw new TSPException(e2.getMessage(), e2.getUnderlyingException());
        }
    }

    public TimeStampTokenInfo getTimeStampInfo() {
        return this.tstInfo;
    }

    public SignerId getSID() {
        return this.tsaSignerInfo.getSID();
    }

    public AttributeTable getSignedAttributes() {
        return this.tsaSignerInfo.getSignedAttributes();
    }

    public AttributeTable getUnsignedAttributes() {
        return this.tsaSignerInfo.getUnsignedAttributes();
    }

    public CertStore getCertificatesAndCRLs(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.tsToken.getCertificatesAndCRLs(type, provider);
    }

    public Store getCertificates() {
        return this.tsToken.getCertificates();
    }

    public Store getCRLs() {
        return this.tsToken.getCRLs();
    }

    public Store getAttributeCertificates() {
        return this.tsToken.getAttributeCertificates();
    }

    public void validate(X509Certificate cert, String provider) throws TSPException, TSPValidationException, CertificateExpiredException, CertificateNotYetValidException, NoSuchProviderException {
        try {
            if (!Arrays.constantTimeAreEqual(this.certID.c(), MessageDigest.getInstance(this.certID.a()).digest(cert.getEncoded()))) {
                throw new TSPValidationException("certificate hash does not match certID hash.");
            }
            if (this.certID.d() != null) {
                if (!this.certID.d().getSerial().getValue().equals(cert.getSerialNumber())) {
                    throw new TSPValidationException("certificate serial number does not match certID for signature.");
                }
                GeneralName[] names = this.certID.d().getIssuer().getNames();
                X509Principal principal = PrincipalUtil.getIssuerX509Principal(cert);
                boolean found = false;
                for (int i2 = 0; i2 != names.length; ++i2) {
                    if (names[i2].getTagNo() != 4 || !new X509Principal(X509Name.getInstance(names[i2].getName())).equals(principal)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TSPValidationException("certificate name does not match certID for signature. ");
                }
            }
            TSPUtil.validateCertificate(cert);
            cert.checkValidity(this.tstInfo.getGenTime());
            if (!this.tsaSignerInfo.verify(cert, provider)) {
                throw new TSPValidationException("signature not created by certificate.");
            }
            return;
        }
        catch (CMSException cMSException) {
            CMSException e2 = cMSException;
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(e2.getMessage(), e2.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + e2, e2);
        }
        catch (NoSuchAlgorithmException e3) {
            throw new TSPException("cannot find algorithm: " + e3, e3);
        }
        catch (CertificateEncodingException e4) {
            throw new TSPException("problem processing certificate: " + e4, e4);
        }
    }

    public void validate(SignerInformationVerifier sigVerifier) throws TSPException, TSPValidationException {
        if (!sigVerifier.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("verifier provider needs an associated certificate");
        }
        try {
            X509CertificateHolder certHolder = sigVerifier.getAssociatedCertificate();
            DigestCalculator calc = sigVerifier.getDigestCalculator(this.certID.b());
            OutputStream cOut = calc.getOutputStream();
            cOut.write(certHolder.getEncoded());
            cOut.close();
            if (!Arrays.constantTimeAreEqual(this.certID.c(), calc.getDigest())) {
                throw new TSPValidationException("certificate hash does not match certID hash.");
            }
            if (this.certID.d() != null) {
                IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber(certHolder.toASN1Structure());
                if (!this.certID.d().getSerial().equals(issuerSerial.getSerialNumber())) {
                    throw new TSPValidationException("certificate serial number does not match certID for signature.");
                }
                GeneralName[] names = this.certID.d().getIssuer().getNames();
                boolean found = false;
                for (int i2 = 0; i2 != names.length; ++i2) {
                    if (names[i2].getTagNo() != 4 || !X500Name.getInstance(names[i2].getName()).equals(X500Name.getInstance(issuerSerial.getName()))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new TSPValidationException("certificate name does not match certID for signature. ");
                }
            }
            TSPUtil.validateCertificate(certHolder);
            if (!certHolder.isValidOn(this.tstInfo.getGenTime())) {
                throw new TSPValidationException("certificate not valid when time stamp created.");
            }
            if (!this.tsaSignerInfo.verify(sigVerifier)) {
                throw new TSPValidationException("signature not created by certificate.");
            }
            return;
        }
        catch (CMSException cMSException) {
            CMSException e2 = cMSException;
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(e2.getMessage(), e2.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + e2, e2);
        }
        catch (IOException e3) {
            throw new TSPException("problem processing certificate: " + e3, e3);
        }
        catch (OperatorCreationException e4) {
            throw new TSPException("unable to create digest: " + e4.getMessage(), e4);
        }
    }

    public boolean isSignatureValid(SignerInformationVerifier sigVerifier) throws TSPException {
        try {
            return this.tsaSignerInfo.verify(sigVerifier);
        }
        catch (CMSException cMSException) {
            CMSException e2 = cMSException;
            if (cMSException.getUnderlyingException() != null) {
                throw new TSPException(e2.getMessage(), e2.getUnderlyingException());
            }
            throw new TSPException("CMS exception: " + e2, e2);
        }
    }

    public CMSSignedData toCMSSignedData() {
        return this.tsToken;
    }

    public byte[] getEncoded() throws IOException {
        return this.tsToken.getEncoded();
    }

    private class a {
        private ESSCertID b;
        private ESSCertIDv2 c;

        a(ESSCertID certID) {
            this.b = certID;
            this.c = null;
        }

        a(ESSCertIDv2 certID) {
            this.c = certID;
            this.b = null;
        }

        public String a() {
            if (this.b != null) {
                return "SHA-1";
            }
            if (NISTObjectIdentifiers.id_sha256.equals(this.c.getHashAlgorithm().getAlgorithm())) {
                return "SHA-256";
            }
            return this.c.getHashAlgorithm().getAlgorithm().getId();
        }

        public AlgorithmIdentifier b() {
            if (this.b != null) {
                return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
            }
            return this.c.getHashAlgorithm();
        }

        public byte[] c() {
            if (this.b != null) {
                return this.b.getCertHash();
            }
            return this.c.getCertHash();
        }

        public IssuerSerial d() {
            if (this.b != null) {
                return this.b.getIssuerSerial();
            }
            return this.c.getIssuerSerial();
        }
    }
}

