/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.encodings;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.InvalidCipherTextException;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import java.security.SecureRandom;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest hash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher cipher) {
        this(cipher, new SHA1Digest(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash) {
        this(cipher, hash, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, byte[] encodingParams) {
        this(cipher, hash, hash, encodingParams);
    }

    public OAEPEncoding(AsymmetricBlockCipher cipher, Digest hash, Digest mgf1Hash, byte[] encodingParams) {
        this.engine = cipher;
        this.hash = hash;
        this.mgf1Hash = mgf1Hash;
        this.defHash = new byte[hash.getDigestSize()];
        if (encodingParams != null) {
            hash.update(encodingParams, 0, encodingParams.length);
        }
        hash.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
        } else {
            this.random = new SecureRandom();
        }
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - 1 - 2 * this.defHash.length;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * this.defHash.length;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int i2;
        byte[] block = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this.defHash, 0, block, this.defHash.length, this.defHash.length);
        byte[] seed = new byte[this.defHash.length];
        this.random.nextBytes(seed);
        byte[] mask = this.maskGeneratorFunction1(seed, 0, seed.length, block.length - this.defHash.length);
        for (i2 = this.defHash.length; i2 != block.length; ++i2) {
            int n2 = i2;
            block[n2] = (byte)(block[n2] ^ mask[i2 - this.defHash.length]);
        }
        System.arraycopy(seed, 0, block, 0, this.defHash.length);
        mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        for (i2 = 0; i2 != this.defHash.length; ++i2) {
            int n3 = i2;
            block[n3] = (byte)(block[n3] ^ mask[i2]);
        }
        return this.engine.processBlock(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int start;
        int i2;
        byte[] block;
        byte[] data = this.engine.processBlock(in, inOff, inLen);
        if (data.length < this.engine.getOutputBlockSize()) {
            block = new byte[this.engine.getOutputBlockSize()];
            System.arraycopy(data, 0, block, block.length - data.length, data.length);
        } else {
            block = data;
        }
        if (block.length < 2 * this.defHash.length + 1) {
            throw new InvalidCipherTextException("data too short");
        }
        byte[] mask = this.maskGeneratorFunction1(block, this.defHash.length, block.length - this.defHash.length, this.defHash.length);
        for (i2 = 0; i2 != this.defHash.length; ++i2) {
            int n2 = i2;
            block[n2] = (byte)(block[n2] ^ mask[i2]);
        }
        mask = this.maskGeneratorFunction1(block, 0, this.defHash.length, block.length - this.defHash.length);
        for (i2 = this.defHash.length; i2 != block.length; ++i2) {
            int n3 = i2;
            block[n3] = (byte)(block[n3] ^ mask[i2 - this.defHash.length]);
        }
        for (i2 = 0; i2 != this.defHash.length; ++i2) {
            if (this.defHash[i2] == block[this.defHash.length + i2]) continue;
            throw new InvalidCipherTextException("data hash wrong");
        }
        for (start = 2 * this.defHash.length; start != block.length && block[start] == 0; ++start) {
        }
        if (start >= block.length - 1 || block[start] != 1) {
            throw new InvalidCipherTextException("data start wrong " + start);
        }
        byte[] output = new byte[block.length - ++start];
        System.arraycopy(block, start, output, 0, output.length);
        return output;
    }

    private void ItoOSP(int i2, byte[] sp) {
        sp[0] = i2 >> 24;
        sp[1] = (byte)(i2 >>> 16);
        sp[2] = (byte)(i2 >>> 8);
        sp[3] = (byte)i2;
    }

    private byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length) {
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[this.mgf1Hash.getDigestSize()];
        byte[] C = new byte[4];
        int counter = 0;
        this.hash.reset();
        do {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, 4);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, hashBuf.length);
        } while (++counter < length / hashBuf.length);
        if (counter * hashBuf.length < length) {
            this.ItoOSP(counter, C);
            this.mgf1Hash.update(Z, zOff, zLen);
            this.mgf1Hash.update(C, 0, 4);
            this.mgf1Hash.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, mask, counter * hashBuf.length, length - counter * hashBuf.length);
        }
        return mask;
    }
}

