/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McEliecePrivateKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int k;
    private byte[] encField;
    private byte[] encGp;
    private byte[] encSInv;
    private byte[] encP1;
    private byte[] encP2;
    private byte[] encH;
    private byte[][] encqInv;

    public McEliecePrivateKey(ASN1ObjectIdentifier oid, int n2, int k2, GF2mField field, PolynomialGF2mSmallM goppaPoly, GF2Matrix sInv, Permutation p1, Permutation p2, GF2Matrix h2, PolynomialGF2mSmallM[] qInv) {
        this.oid = oid;
        this.n = n2;
        this.k = k2;
        this.encField = field.getEncoded();
        this.encGp = goppaPoly.getEncoded();
        this.encSInv = sInv.getEncoded();
        this.encP1 = p1.getEncoded();
        this.encP2 = p2.getEncoded();
        this.encH = h2.getEncoded();
        this.encqInv = new byte[qInv.length][];
        for (int i2 = 0; i2 != qInv.length; ++i2) {
            this.encqInv[i2] = qInv[i2].getEncoded();
        }
    }

    public static McEliecePrivateKey getInstance(Object o2) {
        if (o2 instanceof McEliecePrivateKey) {
            return (McEliecePrivateKey)o2;
        }
        if (o2 != null) {
            return new McEliecePrivateKey(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private McEliecePrivateKey(ASN1Sequence seq) {
        this.oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.n = bigN.intValue();
        BigInteger bigK = ((ASN1Integer)seq.getObjectAt(2)).getValue();
        this.k = bigK.intValue();
        this.encField = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        this.encGp = ((ASN1OctetString)seq.getObjectAt(4)).getOctets();
        this.encSInv = ((ASN1OctetString)seq.getObjectAt(5)).getOctets();
        this.encP1 = ((ASN1OctetString)seq.getObjectAt(6)).getOctets();
        this.encP2 = ((ASN1OctetString)seq.getObjectAt(7)).getOctets();
        this.encH = ((ASN1OctetString)seq.getObjectAt(8)).getOctets();
        ASN1Sequence asnQInv = (ASN1Sequence)seq.getObjectAt(9);
        this.encqInv = new byte[asnQInv.size()][];
        for (int i2 = 0; i2 < asnQInv.size(); ++i2) {
            this.encqInv[i2] = ((ASN1OctetString)asnQInv.getObjectAt(i2)).getOctets();
        }
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return new GF2mField(this.encField);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.encGp);
    }

    public GF2Matrix getSInv() {
        return new GF2Matrix(this.encSInv);
    }

    public Permutation getP1() {
        return new Permutation(this.encP1);
    }

    public Permutation getP2() {
        return new Permutation(this.encP2);
    }

    public GF2Matrix getH() {
        return new GF2Matrix(this.encH);
    }

    public PolynomialGF2mSmallM[] getQInv() {
        PolynomialGF2mSmallM[] qInv = new PolynomialGF2mSmallM[this.encqInv.length];
        GF2mField field = this.getField();
        for (int i2 = 0; i2 < this.encqInv.length; ++i2) {
            qInv[i2] = new PolynomialGF2mSmallM(field, this.encqInv[i2]);
        }
        return qInv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.oid);
        v2.add(new ASN1Integer(this.n));
        v2.add(new ASN1Integer(this.k));
        v2.add(new DEROctetString(this.encField));
        v2.add(new DEROctetString(this.encGp));
        v2.add(new DEROctetString(this.encSInv));
        v2.add(new DEROctetString(this.encP1));
        v2.add(new DEROctetString(this.encP2));
        v2.add(new DEROctetString(this.encH));
        ASN1EncodableVector asnQInv = new ASN1EncodableVector();
        for (int i2 = 0; i2 < this.encqInv.length; ++i2) {
            asnQInv.add(new DEROctetString(this.encqInv[i2]));
        }
        v2.add(new DERSequence(asnQInv));
        return new DERSequence(v2);
    }
}

