/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x9;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.x9.KeySpecificInfo;
import java.util.Enumeration;

public class OtherInfo
extends ASN1Object {
    private KeySpecificInfo keyInfo;
    private ASN1OctetString partyAInfo;
    private ASN1OctetString suppPubInfo;

    public OtherInfo(KeySpecificInfo keyInfo, ASN1OctetString partyAInfo, ASN1OctetString suppPubInfo) {
        this.keyInfo = keyInfo;
        this.partyAInfo = partyAInfo;
        this.suppPubInfo = suppPubInfo;
    }

    public OtherInfo(ASN1Sequence seq) {
        Enumeration e2 = seq.getObjects();
        this.keyInfo = new KeySpecificInfo((ASN1Sequence)e2.nextElement());
        while (e2.hasMoreElements()) {
            DERTaggedObject o2 = (DERTaggedObject)e2.nextElement();
            if (o2.getTagNo() == 0) {
                this.partyAInfo = (ASN1OctetString)o2.getObject();
                continue;
            }
            if (o2.getTagNo() != 2) continue;
            this.suppPubInfo = (ASN1OctetString)o2.getObject();
        }
    }

    public KeySpecificInfo getKeyInfo() {
        return this.keyInfo;
    }

    public ASN1OctetString getPartyAInfo() {
        return this.partyAInfo;
    }

    public ASN1OctetString getSuppPubInfo() {
        return this.suppPubInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.keyInfo);
        if (this.partyAInfo != null) {
            v2.add(new DERTaggedObject(0, this.partyAInfo));
        }
        v2.add(new DERTaggedObject(2, this.suppPubInfo));
        return new DERSequence(v2);
    }
}

