/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.smime;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.smime.SMIMECapability;
import java.util.Enumeration;
import java.util.Vector;

public class SMIMECapabilities
extends ASN1Object {
    public static final ASN1ObjectIdentifier preferSignedData = PKCSObjectIdentifiers.preferSignedData;
    public static final ASN1ObjectIdentifier canNotDecryptAny = PKCSObjectIdentifiers.canNotDecryptAny;
    public static final ASN1ObjectIdentifier sMIMECapabilitesVersions = PKCSObjectIdentifiers.sMIMECapabilitiesVersions;
    public static final ASN1ObjectIdentifier dES_CBC = new ASN1ObjectIdentifier("1.3.14.3.2.7");
    public static final ASN1ObjectIdentifier dES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
    public static final ASN1ObjectIdentifier rC2_CBC = PKCSObjectIdentifiers.RC2_CBC;
    private ASN1Sequence capabilities;

    public static SMIMECapabilities getInstance(Object o2) {
        if (o2 == null || o2 instanceof SMIMECapabilities) {
            return (SMIMECapabilities)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new SMIMECapabilities((ASN1Sequence)o2);
        }
        if (o2 instanceof Attribute) {
            return new SMIMECapabilities((ASN1Sequence)((Attribute)o2).getAttrValues().getObjectAt(0));
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public SMIMECapabilities(ASN1Sequence seq) {
        this.capabilities = seq;
    }

    public Vector getCapabilities(ASN1ObjectIdentifier capability) {
        Enumeration e2 = this.capabilities.getObjects();
        Vector<SMIMECapability> list = new Vector<SMIMECapability>();
        if (capability == null) {
            while (e2.hasMoreElements()) {
                SMIMECapability cap = SMIMECapability.getInstance(e2.nextElement());
                list.addElement(cap);
            }
        } else {
            while (e2.hasMoreElements()) {
                SMIMECapability cap = SMIMECapability.getInstance(e2.nextElement());
                if (!capability.equals(cap.getCapabilityID())) continue;
                list.addElement(cap);
            }
        }
        return list;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.capabilities;
    }
}

