/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.BigEndianConversions;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import java.math.BigInteger;

public final class IntUtils {
    private IntUtils() {
    }

    public static boolean equals(int[] left, int[] right) {
        if (left.length != right.length) {
            return false;
        }
        boolean result = true;
        for (int i2 = left.length - 1; i2 >= 0; --i2) {
            result &= left[i2] == right[i2];
        }
        return result;
    }

    public static int[] clone(int[] array) {
        int[] result = new int[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static void fill(int[] array, int value) {
        for (int i2 = array.length - 1; i2 >= 0; --i2) {
            array[i2] = value;
        }
    }

    public static void quicksort(int[] source) {
        IntUtils.quicksort(source, 0, source.length - 1);
    }

    public static void quicksort(int[] source, int left, int right) {
        if (right > left) {
            int index = IntUtils.partition(source, left, right, right);
            IntUtils.quicksort(source, left, index - 1);
            IntUtils.quicksort(source, index + 1, right);
        }
    }

    private static int partition(int[] source, int left, int right, int pivotIndex) {
        int pivot = source[pivotIndex];
        source[pivotIndex] = source[right];
        source[right] = pivot;
        int index = left;
        for (int i2 = left; i2 < right; ++i2) {
            if (source[i2] > pivot) continue;
            int tmp = source[index];
            source[index] = source[i2];
            source[i2] = tmp;
            ++index;
        }
        int tmp = source[index];
        source[index] = source[right];
        source[right] = tmp;
        return index;
    }

    public static int[] subArray(int[] input, int start, int end) {
        int[] result = new int[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static BigInteger[] toFlexiBigIntArray(int[] input) {
        BigInteger[] result = new BigInteger[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            result[i2] = BigInteger.valueOf(input[i2]);
        }
        return result;
    }

    public static String toString(int[] input) {
        String result = "";
        for (int i2 = 0; i2 < input.length; ++i2) {
            result = result + input[i2] + " ";
        }
        return result;
    }

    public static String toHexString(int[] input) {
        return ByteUtils.toHexString(BigEndianConversions.toByteArray(input));
    }
}

