/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.math.ec;

import com.timevale.tgtext.bouncycastle.asn1.x9.X9IntegerConverter;
import com.timevale.tgtext.bouncycastle.math.ec.ECConstants;
import com.timevale.tgtext.bouncycastle.math.ec.ECCurve;
import com.timevale.tgtext.bouncycastle.math.ec.ECFieldElement;
import com.timevale.tgtext.bouncycastle.math.ec.a;
import com.timevale.tgtext.bouncycastle.math.ec.b;
import com.timevale.tgtext.bouncycastle.math.ec.d;
import com.timevale.tgtext.bouncycastle.math.ec.h;
import com.timevale.tgtext.bouncycastle.math.ec.j;
import java.math.BigInteger;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    protected boolean withCompression;
    protected a multiplier = null;
    protected d preCompInfo = null;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected ECPoint(ECCurve curve, ECFieldElement x2, ECFieldElement y2) {
        this.curve = curve;
        this.x = x2;
        this.y = y2;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean isCompressed() {
        return this.withCompression;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECPoint)) {
            return false;
        }
        ECPoint o2 = (ECPoint)other;
        if (this.isInfinity()) {
            return o2.isInfinity();
        }
        return this.x.equals(o2.x) && this.y.equals(o2.y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    void setPreCompInfo(d preCompInfo) {
        this.preCompInfo = preCompInfo;
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint negate();

    public abstract ECPoint twice();

    synchronized void assertECMultiplier() {
        if (this.multiplier == null) {
            this.multiplier = new b();
        }
    }

    public ECPoint multiply(BigInteger k2) {
        if (k2.signum() < 0) {
            throw new IllegalArgumentException("The multiplicator cannot be negative");
        }
        if (this.isInfinity()) {
            return this;
        }
        if (k2.signum() == 0) {
            return this.curve.getInfinity();
        }
        this.assertECMultiplier();
        return this.multiplier.a(this, k2, this.preCompInfo);
    }

    public static class F2m
    extends ECPoint {
        public F2m(ECCurve curve, ECFieldElement x2, ECFieldElement y2) {
            this(curve, x2, y2, false);
        }

        public F2m(ECCurve curve, ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
            super(curve, x2, y2);
            if (x2 != null && y2 == null || x2 == null && y2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (x2 != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (curve != null) {
                    ECFieldElement.F2m.checkFieldElements(this.x, this.curve.getA());
                }
            }
            this.withCompression = withCompression;
        }

        @Override
        public byte[] getEncoded() {
            byte[] PO;
            if (this.isInfinity()) {
                return new byte[1];
            }
            int byteCount = converter.getByteLength(this.x);
            byte[] X = converter.integerToBytes(this.getX().toBigInteger(), byteCount);
            if (this.withCompression) {
                byte[] byArray = new byte[byteCount + 1];
                PO = byArray;
                byArray[0] = 2;
                if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                    PO[0] = 3;
                }
                System.arraycopy(X, 0, PO, 1, byteCount);
            } else {
                byte[] Y = converter.integerToBytes(this.getY().toBigInteger(), byteCount);
                byte[] byArray = new byte[byteCount + byteCount + 1];
                PO = byArray;
                byArray[0] = 4;
                System.arraycopy(X, 0, PO, 1, byteCount);
                System.arraycopy(Y, 0, PO, byteCount + 1, byteCount);
            }
            return PO;
        }

        private static void checkPoints(ECPoint a2, ECPoint b2) {
            if (!a2.curve.equals(b2.curve)) {
                throw new IllegalArgumentException("Only points on the same curve can be added or subtracted");
            }
        }

        @Override
        public ECPoint add(ECPoint b2) {
            F2m.checkPoints(this, b2);
            return this.addSimple((F2m)b2);
        }

        public F2m addSimple(F2m b2) {
            F2m other = b2;
            if (this.isInfinity()) {
                return other;
            }
            if (other.isInfinity()) {
                return this;
            }
            ECFieldElement.F2m x2 = (ECFieldElement.F2m)other.getX();
            ECFieldElement.F2m y2 = (ECFieldElement.F2m)other.getY();
            if (this.x.equals(x2)) {
                if (this.y.equals(y2)) {
                    return (F2m)this.twice();
                }
                return (F2m)this.curve.getInfinity();
            }
            ECFieldElement.F2m lambda = (ECFieldElement.F2m)this.y.add(y2).divide(this.x.add(x2));
            ECFieldElement.F2m x3 = (ECFieldElement.F2m)lambda.square().add(lambda).add(this.x).add(x2).add(this.curve.getA());
            ECFieldElement.F2m y3 = (ECFieldElement.F2m)lambda.multiply(this.x.add(x3)).add(x3).add(this.y);
            return new F2m(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint b2) {
            F2m.checkPoints(this, b2);
            return this.subtractSimple((F2m)b2);
        }

        public F2m subtractSimple(F2m b2) {
            if (b2.isInfinity()) {
                return this;
            }
            return this.addSimple((F2m)b2.negate());
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.x.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement.F2m lambda = (ECFieldElement.F2m)this.x.add(this.y.divide(this.x));
            ECFieldElement.F2m x3 = (ECFieldElement.F2m)lambda.square().add(lambda).add(this.curve.getA());
            ECFieldElement ONE = this.curve.fromBigInteger(ECConstants.ONE);
            ECFieldElement.F2m y3 = (ECFieldElement.F2m)this.x.square().add(x3.multiply(lambda.add(ONE)));
            return new F2m(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint negate() {
            return new F2m(this.curve, this.getX(), this.getY().add(this.getX()), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                if (((ECCurve.F2m)this.curve).isKoblitz()) {
                    this.multiplier = new j();
                    return;
                }
                this.multiplier = new h();
            }
        }
    }

    public static class Fp
    extends ECPoint {
        public Fp(ECCurve curve, ECFieldElement x2, ECFieldElement y2) {
            this(curve, x2, y2, false);
        }

        public Fp(ECCurve curve, ECFieldElement x2, ECFieldElement y2, boolean withCompression) {
            super(curve, x2, y2);
            if (x2 != null && y2 == null || x2 == null && y2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = withCompression;
        }

        @Override
        public byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            int qLength = converter.getByteLength(this.x);
            if (this.withCompression) {
                int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
                byte[] byArray = new byte[X.length + 1];
                byte[] PO = byArray;
                byArray[0] = PC;
                System.arraycopy(X, 0, PO, 1, X.length);
                return PO;
            }
            byte[] X = converter.integerToBytes(this.getX().toBigInteger(), qLength);
            byte[] Y = converter.integerToBytes(this.getY().toBigInteger(), qLength);
            byte[] byArray = new byte[X.length + Y.length + 1];
            byte[] PO = byArray;
            byArray[0] = 4;
            System.arraycopy(X, 0, PO, 1, X.length);
            System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
            return PO;
        }

        @Override
        public ECPoint add(ECPoint b2) {
            if (this.isInfinity()) {
                return b2;
            }
            if (b2.isInfinity()) {
                return this;
            }
            if (this.x.equals(b2.x)) {
                if (this.y.equals(b2.y)) {
                    return this.twice();
                }
                return this.curve.getInfinity();
            }
            ECFieldElement gamma = b2.y.subtract(this.y).divide(b2.x.subtract(this.x));
            ECFieldElement x3 = gamma.square().subtract(this.x).subtract(b2.x);
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        @Override
        public ECPoint twice() {
            if (this.isInfinity()) {
                return this;
            }
            if (this.y.toBigInteger().signum() == 0) {
                return this.curve.getInfinity();
            }
            ECFieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement gamma = this.x.square().multiply(THREE).add(this.curve.a).divide(this.y.multiply(TWO));
            ECFieldElement x3 = gamma.square().subtract(this.x.multiply(TWO));
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3, this.withCompression);
        }

        @Override
        public ECPoint subtract(ECPoint b2) {
            if (b2.isInfinity()) {
                return this;
            }
            return this.add(b2.negate());
        }

        @Override
        public ECPoint negate() {
            return new Fp(this.curve, this.x, this.y.negate(), this.withCompression);
        }

        @Override
        synchronized void assertECMultiplier() {
            if (this.multiplier == null) {
                this.multiplier = new h();
            }
        }
    }
}

