/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.crmf;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CertRequest;
import com.timevale.tgtext.bouncycastle.asn1.crmf.ProofOfPossession;
import java.util.Enumeration;

public class CertReqMsg
extends ASN1Object {
    private CertRequest certReq;
    private ProofOfPossession pop;
    private ASN1Sequence regInfo;

    private CertReqMsg(ASN1Sequence seq) {
        Enumeration en2 = seq.getObjects();
        this.certReq = CertRequest.getInstance(en2.nextElement());
        while (en2.hasMoreElements()) {
            Object o2 = en2.nextElement();
            if (o2 instanceof ASN1TaggedObject || o2 instanceof ProofOfPossession) {
                this.pop = ProofOfPossession.getInstance(o2);
                continue;
            }
            this.regInfo = ASN1Sequence.getInstance(o2);
        }
    }

    public static CertReqMsg getInstance(Object o2) {
        if (o2 instanceof CertReqMsg) {
            return (CertReqMsg)o2;
        }
        if (o2 != null) {
            return new CertReqMsg(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertReqMsg(CertRequest certReq, ProofOfPossession pop, AttributeTypeAndValue[] regInfo) {
        if (certReq == null) {
            throw new IllegalArgumentException("'certReq' cannot be null");
        }
        this.certReq = certReq;
        this.pop = pop;
        if (regInfo != null) {
            this.regInfo = new DERSequence(regInfo);
        }
    }

    public CertRequest getCertReq() {
        return this.certReq;
    }

    public ProofOfPossession getPop() {
        return this.pop;
    }

    public ProofOfPossession getPopo() {
        return this.pop;
    }

    public AttributeTypeAndValue[] getRegInfo() {
        if (this.regInfo == null) {
            return null;
        }
        AttributeTypeAndValue[] results = new AttributeTypeAndValue[this.regInfo.size()];
        for (int i2 = 0; i2 != results.length; ++i2) {
            results[i2] = AttributeTypeAndValue.getInstance(this.regInfo.getObjectAt(i2));
        }
        return results;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(this.certReq);
        this.addOptional(v2, this.pop);
        this.addOptional(v2, this.regInfo);
        return new DERSequence(v2);
    }

    private void addOptional(ASN1EncodableVector v2, ASN1Encodable obj) {
        if (obj != null) {
            v2.add(obj);
        }
    }
}

